/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.content;

import com.atlassian.stash.content.AttributeMap;
import com.atlassian.stash.content.Changeset;
import com.atlassian.stash.content.InternalMinimalChangeset;
import com.atlassian.stash.content.MinimalChangeset;
import com.atlassian.stash.property.PropertyMap;
import com.atlassian.stash.property.PropertySupport;
import com.atlassian.stash.property.SimplePropertySupport;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.user.Person;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

@Deprecated
public class InternalChangeset
extends InternalMinimalChangeset
implements Changeset,
Serializable {
    private final Person author;
    private final Date authorTimestamp;
    private final String message;
    private final List<MinimalChangeset> parents;
    private transient SimplePropertySupport propertySupport;
    private transient Repository repository;

    private InternalChangeset(Builder builder) {
        super(builder.id, builder.displayId);
        this.propertySupport = new SimplePropertySupport((SimplePropertySupport.AbstractPropertyBuilder)builder);
        this.author = builder.author;
        this.authorTimestamp = builder.authorTimestamp;
        this.message = builder.message;
        this.parents = ImmutableList.copyOf((Collection)builder.parents);
        this.repository = builder.repository;
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o) && o instanceof InternalChangeset) {
            InternalChangeset that = (InternalChangeset)o;
            return Objects.equal((Object)this.getAuthor(), (Object)that.getAuthor()) && Objects.equal((Object)this.getAuthorTimestamp(), (Object)that.getAuthorTimestamp()) && Objects.equal((Object)this.getMessage(), (Object)that.getMessage());
        }
        return false;
    }

    @Nonnull
    public AttributeMap getAttributes() {
        return this.propertySupport.getAttributes();
    }

    @Nonnull
    public Set<String> getAttributeValues(String name) {
        return this.propertySupport.getAttributeValues(name);
    }

    @Nonnull
    public PropertyMap getProperties() {
        return this.propertySupport.getProperties();
    }

    @Nonnull
    public Person getAuthor() {
        return this.author;
    }

    public Date getAuthorTimestamp() {
        return this.authorTimestamp;
    }

    public String getMessage() {
        return this.message;
    }

    public List<MinimalChangeset> getParents() {
        return this.parents;
    }

    public Repository getRepository() {
        return this.repository;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getId(), this.getAuthor(), this.getAuthorTimestamp(), this.getMessage()});
    }

    public void setAttributes(AttributeMap attributes) {
        this.propertySupport.setAttributes(attributes);
    }

    public void setProperties(@Nonnull PropertyMap properties) {
        this.propertySupport.setProperties(properties);
    }

    public void setRepository(Repository repository) {
        if (this.repository != null) {
            throw new IllegalStateException("Repository has already been set; you cannot override once set.");
        }
        this.repository = repository;
    }

    @Override
    public String toString() {
        return "InternalChangeset{id='" + this.getId() + "', author='" + this.getAuthor() + "', authorTimestamp=" + this.getAuthorTimestamp() + ", message='" + this.getMessage() + "'}";
    }

    public static final class Builder
    extends SimplePropertySupport.AbstractPropertyBuilder<Builder> {
        private Person author;
        private Date authorTimestamp;
        private String displayId;
        private String id;
        private String message;
        private List<MinimalChangeset> parents;
        private Repository repository;

        public Builder(Repository repository) {
            this.repository = repository;
            this.parents = new ArrayList<MinimalChangeset>(2);
        }

        public Builder(Changeset changeset) {
            super((PropertySupport)changeset);
            this.author = changeset.getAuthor();
            this.authorTimestamp = changeset.getAuthorTimestamp();
            this.id = changeset.getId();
            this.displayId = changeset.getDisplayId();
            this.message = changeset.getMessage();
            this.parents = Lists.newArrayList((Iterable)changeset.getParents());
            this.repository = changeset.getRepository();
        }

        public Builder addParent(String parent) {
            return this.addParent(new InternalMinimalChangeset(parent));
        }

        public Builder addParent(MinimalChangeset parent) {
            this.parents.add(parent);
            return this;
        }

        public Builder author(Person value) {
            this.author = value;
            return this;
        }

        public Builder authorTimestamp(Date value) {
            this.authorTimestamp = value != null ? new Date(value.getTime()) : null;
            return this;
        }

        public InternalChangeset build() {
            return new InternalChangeset(this);
        }

        public Builder displayId(String value) {
            this.displayId = value;
            return this;
        }

        public Builder id(String value) {
            this.id = value;
            return this;
        }

        public Builder message(String value) {
            this.message = value;
            return this;
        }

        public Builder parent(MinimalChangeset value) {
            this.parents = Lists.newArrayList((Object[])new MinimalChangeset[]{value});
            return this;
        }

        public Builder parents(List<MinimalChangeset> value) {
            if (value == null) {
                this.parents.clear();
            } else {
                this.parents = value;
            }
            return this;
        }

        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

