/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.content;

import com.atlassian.stash.content.AbstractContentTreeCallback;
import com.atlassian.stash.content.ContentTreeNode;
import com.atlassian.stash.content.ContentTreeSummary;
import com.atlassian.stash.content.DirectoryRevision;
import com.atlassian.stash.content.InternalDirectoryRevision;
import com.atlassian.stash.content.Path;
import com.atlassian.stash.content.SimplePath;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageUtils;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;

public class DirRevisionTreeCallback
extends AbstractContentTreeCallback {
    private final String path;
    private final String changesetId;
    private final List<ContentTreeNode> nodes;
    private DirectoryRevision dir;

    public DirRevisionTreeCallback(String path, String changesetId) {
        this.path = path;
        this.changesetId = changesetId;
        this.nodes = Lists.newArrayList();
    }

    public boolean onTreeNode(@Nonnull ContentTreeNode node) throws IOException {
        this.nodes.add(node);
        return true;
    }

    public void onEnd(@Nonnull ContentTreeSummary summary) throws IOException {
        this.dir = new InternalDirectoryRevision((Path)new SimplePath((CharSequence)this.path), this.changesetId, (Page<ContentTreeNode>)PageUtils.createPage(this.nodes, (boolean)summary.isLastPage(), (PageRequest)summary.getPageRequest()));
    }

    public DirectoryRevision getDirRevision() {
        return this.dir;
    }
}

