/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.rest.util;

import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.rest.util.NotFoundException;

public class RestResource {
    protected I18nService i18nService;

    public RestResource(I18nService i18nService) {
        this.i18nService = i18nService;
    }

    public NotFoundException noSuchRepoException(String projectKey, String repositorySlug) {
        String message = this.i18nService.getMessage("stash.rest.nosuchrepo", new Object[]{projectKey, repositorySlug});
        return new NotFoundException(message);
    }

    public NotFoundException noSuchProjectException(String projectKey) {
        String message = this.i18nService.getMessage("stash.rest.nosuchproject", new Object[]{projectKey});
        return new NotFoundException(message);
    }

    public NotFoundException noSuchUserException(String name) {
        String message = this.i18nService.getMessage("stash.rest.nosuchuser", new Object[]{name});
        return new NotFoundException(message);
    }

    public NotFoundException noSuchGroupException(String name) {
        String message = this.i18nService.getMessage("stash.rest.nosuchgroup", new Object[]{name});
        return new NotFoundException(message);
    }

    public NotFoundException noSuchPullRequestException(String projectKey, String repositorySlug, long pullRequestId) {
        String message = this.i18nService.getMessage("stash.rest.nosuchpullrequest", new Object[]{pullRequestId, repositorySlug, projectKey});
        return new NotFoundException(message);
    }

    public NotFoundException noSuchCommentException(long comment) {
        String message = this.i18nService.getMessage("stash.rest.nosuchcomment", new Object[]{comment});
        return new NotFoundException(message);
    }

    public I18nService getI18nService() {
        return this.i18nService;
    }
}

