/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.rest.util;

import com.atlassian.stash.rest.data.RestErrorMessage;
import com.atlassian.stash.rest.data.RestErrors;
import com.atlassian.stash.rest.util.ResourceException;
import com.atlassian.stash.rest.util.ResponseFactory;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.core.Response;

public class BadRequestException
extends ResourceException {
    private static final long serialVersionUID = 9187161493815859599L;

    public BadRequestException(String message) {
        this(null, message);
    }

    public BadRequestException(@Nullable String context, @Nullable String message) {
        super(ResponseFactory.status(Response.Status.BAD_REQUEST).entity((Object)new RestErrors(context, message)));
    }

    public BadRequestException(@Nonnull Iterable<String> messages) {
        super(ResponseFactory.status(Response.Status.BAD_REQUEST).entity((Object)BadRequestException.asRestErrors((Iterable)Preconditions.checkNotNull(messages, (Object)"messages"))));
    }

    private static RestErrors asRestErrors(Iterable<String> messages) {
        RestErrors.Builder errors = new RestErrors.Builder();
        for (String message : messages) {
            errors.add(new RestErrorMessage(message));
        }
        return errors.build();
    }
}

