/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.rest.model.commit;

import com.atlassian.stash.commit.Changeset;
import com.atlassian.stash.content.Change;
import com.atlassian.stash.nav.NavBuilder;
import com.atlassian.stash.rest.annotations.JsonSurrogate;
import com.atlassian.stash.rest.data.RestChange;
import com.atlassian.stash.rest.data.RestLink;
import com.atlassian.stash.rest.data.RestLinkedMapEntity;
import com.atlassian.stash.rest.data.RestPage;
import com.atlassian.stash.rest.data.RestRelatedLinks;
import com.atlassian.stash.rest.data.RestRepository;
import com.atlassian.stash.rest.docs.RestDocletHelper;
import com.atlassian.stash.rest.model.commit.RestCommit;
import com.atlassian.stash.rest.model.commit.RestMinimalCommit;
import com.atlassian.stash.util.Page;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=Changeset.class)
public class RestChangeset
extends RestLinkedMapEntity {
    public static final RestChangeset EXAMPLE = new RestChangeset(RestMinimalCommit.EXAMPLE, RestCommit.EXAMPLE, RestChange.PAGE_EXAMPLE, RestDocletHelper.selfLink(Changeset.class), RestRepository.RESPONSE_EXAMPLE, RestDocletHelper.selfLink(Changeset.class).toSingleRelatedLink());
    public static final RestPage<RestChangeset> PAGE_EXAMPLE = RestDocletHelper.pageOf(EXAMPLE);

    public RestChangeset(Changeset changeset, NavBuilder navBuilder) {
        this(changeset, navBuilder, true);
    }

    public RestChangeset(Changeset changeset, NavBuilder navBuilder, boolean includeRepository) {
        this(changeset, navBuilder.repo(changeset.getToCommit().getRepository()).commit(changeset.getToCommit().getId()), includeRepository);
    }

    private RestChangeset(Changeset changeset, NavBuilder.Commit changesetNav, boolean includeRepository) {
        this((RestMinimalCommit)RestMinimalCommit.REST_TRANSFORM.apply((Object)changeset.getFromCommit()), new RestCommit(changeset.getToCommit()), RestChangeset.transform((Page<? extends Change>)changeset.getChanges(), changesetNav), new RestLink("self", changesetNav.buildRelNoContext()), includeRepository ? new RestRepository(changeset.getToCommit().getRepository(), true) : null, new RestLink("self", changesetNav.buildAbsolute()).toSingleRelatedLink());
    }

    private RestChangeset(RestMinimalCommit fromCommit, RestCommit toCommit, RestPage<RestChange> changes, RestLink link, RestRepository repository, RestRelatedLinks relatedLinks) {
        this.put("fromCommit", fromCommit);
        this.put("toCommit", toCommit);
        this.put("changes", changes);
        this.setSelfLink(link);
        this.setLinks(relatedLinks);
        this.putIfNotNull("repository", repository);
    }

    private static RestPage<RestChange> transform(Page<? extends Change> changes, NavBuilder.Commit changesetNav) {
        return changes == null ? null : new RestPage<RestChange>(changes, RestChange.transform(changesetNav));
    }
}

