/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.rest.enrich;

import com.atlassian.stash.avatar.AvatarRequest;
import com.atlassian.stash.avatar.AvatarService;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.rest.data.RestPerson;
import com.atlassian.stash.rest.data.RestProject;
import com.atlassian.stash.rest.enrich.AvatarEnricher;
import com.atlassian.stash.rest.util.RestUtils;
import com.atlassian.stash.user.Person;
import com.atlassian.stash.util.Timer;
import com.atlassian.stash.util.TimerUtils;
import com.google.common.base.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DefaultAvatarEnricher
implements AvatarEnricher {
    private final AvatarService avatarService;

    public DefaultAvatarEnricher(AvatarService avatarService) {
        this.avatarService = avatarService;
    }

    @Override
    public void enrich(@Nonnull Object entity, @Nullable AvatarRequest avatarRequest) {
        if (avatarRequest != null) {
            try (Timer ignored = TimerUtils.start((String)"AvatarEnricher.enrich");){
                this.setAvatarUrls(entity, avatarRequest);
            }
        }
    }

    private void setAvatarUrls(Object entity, final AvatarRequest request) {
        RestUtils.processEntities(entity, new Function<Object, Object>(){

            public Object apply(Object entity) {
                if (entity instanceof RestPerson) {
                    RestPerson person = (RestPerson)entity;
                    person.setAvatarUrl(DefaultAvatarEnricher.this.avatarService.getUrlForPerson((Person)person, request));
                } else if (entity instanceof RestProject) {
                    RestProject project = (RestProject)entity;
                    project.setAvatarUrl(DefaultAvatarEnricher.this.avatarService.getUrlForProject((Project)project, request));
                }
                return entity;
            }
        });
    }
}

