/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.rest.data;

import com.atlassian.stash.project.PersonalProject;
import com.atlassian.stash.project.ProjectType;
import com.atlassian.stash.project.ProjectVisitor;
import com.atlassian.stash.rest.annotations.JsonSurrogate;
import com.atlassian.stash.rest.data.RestProject;
import com.atlassian.stash.rest.data.RestStashUser;
import com.atlassian.stash.user.StashUser;
import javax.annotation.Nonnull;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=PersonalProject.class)
public class RestPersonalProject
extends RestProject
implements PersonalProject {
    private static final String OWNER = "owner";

    public RestPersonalProject() {
    }

    public RestPersonalProject(PersonalProject project) {
        this(project.getId(), project.getKey(), project.getName(), project.getDescription(), project.getOwner());
    }

    private RestPersonalProject(Integer id, String key, String name, String description, StashUser owner) {
        super(id, key, name, description, ProjectType.PERSONAL, null);
        if (owner != null) {
            this.put(OWNER, new RestStashUser(owner));
        }
    }

    @Override
    public <T> T accept(@Nonnull ProjectVisitor<T> visitor) {
        return (T)visitor.visit((PersonalProject)this);
    }

    @Nonnull
    public StashUser getOwner() {
        return RestStashUser.valueOf(this.get(OWNER));
    }
}

