/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.rest.data;

import com.atlassian.stash.exception.ServiceException;
import com.atlassian.stash.rest.annotations.JsonSurrogate;
import com.atlassian.stash.rest.data.RestMapEntity;
import java.util.Map;
import javax.annotation.Nullable;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=ServiceException.class)
public class RestErrorMessage
extends RestMapEntity {
    public static final String CONTEXT = "context";
    public static final String MESSAGE = "message";
    public static final String EXCEPTION_NAME = "exceptionName";

    public RestErrorMessage(Map<String, Object> values) {
        this.putAll(values);
    }

    public RestErrorMessage(String context, String message) {
        this(context, message, null);
    }

    public RestErrorMessage(String context, String message, String exceptionName) {
        this.put(CONTEXT, context);
        this.put(MESSAGE, message);
        this.put(EXCEPTION_NAME, exceptionName);
    }

    public RestErrorMessage(String message) {
        this(null, message, null);
    }

    public RestErrorMessage(ServiceException e) {
        this(null, e.getLocalizedMessage(), e.getClass().getCanonicalName());
    }

    public RestErrorMessage(String context, Exception e) {
        this(context, e.getLocalizedMessage(), e.getClass().getCanonicalName());
    }

    @Nullable
    public String getContext() {
        return this.getStringProperty(CONTEXT);
    }

    @Nullable
    public String getMessage() {
        return this.getStringProperty(MESSAGE);
    }

    @Nullable
    public String getExceptionName() {
        return this.getStringProperty(EXCEPTION_NAME);
    }

    public static RestErrorMessage valueOf(Object value) {
        if (value instanceof RestErrorMessage) {
            return (RestErrorMessage)value;
        }
        if (value instanceof Map) {
            return new RestErrorMessage((Map)value);
        }
        return null;
    }
}

