/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.rest.exception;

import com.atlassian.stash.exception.NoSuchEntityException;
import com.atlassian.stash.exception.ServiceException;
import com.atlassian.stash.nav.NavBuilder;
import com.atlassian.stash.request.RequestManager;
import com.atlassian.stash.request.RequestMetadata;
import com.atlassian.stash.rest.data.RestErrors;
import com.atlassian.stash.rest.exception.ConstraintViolationExceptionMapper;
import com.atlassian.stash.rest.exception.JsonParseExceptionMapper;
import com.atlassian.stash.rest.exception.NoSuchEntityExceptionMapper;
import com.atlassian.stash.rest.exception.ResourceContextInjectionFailedException;
import com.atlassian.stash.rest.exception.ResourceExceptionMapper;
import com.atlassian.stash.rest.exception.ServiceExceptionMapper;
import com.atlassian.stash.rest.exception.UnhandledExceptionMapperHelper;
import com.atlassian.stash.rest.exception.UnrecognizedPropertyExceptionMapper;
import com.atlassian.stash.rest.exception.WebApplicationExceptionMapper;
import com.atlassian.stash.rest.util.ResourceException;
import com.atlassian.stash.rest.util.ResponseFactory;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.validation.ConstraintViolationException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.exc.UnrecognizedPropertyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnhandledExceptionMapper
implements ExceptionMapper<Exception> {
    private static final Logger log = LoggerFactory.getLogger(UnhandledExceptionMapper.class);
    private final Map<Class<?>, ExceptionMapper<?>> mappers;
    private final RequestManager requestManager;

    public UnhandledExceptionMapper(UnhandledExceptionMapperHelper helper) {
        ImmutableMap.Builder<Class<?>, ExceptionMapper<?>> builder = UnhandledExceptionMapper.createDefaultMappers(helper.getNavBuilder());
        UnhandledExceptionMapper.addMapper(builder, NoSuchEntityException.class, new NoSuchEntityExceptionMapper(helper.getAuthenticationContext(), helper.getI18nService()));
        this.mappers = builder.build();
        this.requestManager = helper.getRequestManager();
    }

    private static ImmutableMap.Builder<Class<?>, ExceptionMapper<?>> createDefaultMappers(NavBuilder navBuilder) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        UnhandledExceptionMapper.addMapper(builder, ServiceException.class, new ServiceExceptionMapper(navBuilder));
        UnhandledExceptionMapper.addMapper(builder, ConstraintViolationException.class, new ConstraintViolationExceptionMapper());
        UnhandledExceptionMapper.addMapper(builder, WebApplicationException.class, new WebApplicationExceptionMapper());
        UnhandledExceptionMapper.addMapper(builder, ResourceException.class, new ResourceExceptionMapper());
        UnhandledExceptionMapper.addMapper(builder, UnrecognizedPropertyException.class, new UnrecognizedPropertyExceptionMapper());
        UnhandledExceptionMapper.addMapper(builder, JsonParseException.class, new JsonParseExceptionMapper());
        return builder;
    }

    private static <T extends Exception> void addMapper(ImmutableMap.Builder<Class<?>, ExceptionMapper<?>> builder, Class<T> exceptionClass, ExceptionMapper<T> exceptionMapper) {
        builder.put(exceptionClass, exceptionMapper);
    }

    public Response toResponse(Exception exception) {
        if (exception instanceof ResourceContextInjectionFailedException && exception.getCause() instanceof Exception) {
            exception = (Exception)exception.getCause();
        }
        Class<?> exceptionClass = exception.getClass();
        while (!exceptionClass.equals(Exception.class)) {
            Response response;
            ExceptionMapper<?> mapper = this.mappers.get(exceptionClass);
            if (mapper != null && (response = mapper.toResponse((Throwable)exception)) != null) {
                return response;
            }
            exceptionClass = exceptionClass.getSuperclass();
        }
        RequestMetadata metadata = this.requestManager.getRequestMetadata();
        if (metadata == null) {
            log.error("Unhandled exception while processing REST request, but no request is active", (Throwable)exception);
        } else {
            log.error("Unhandled exception while processing REST request: {}", (Object)metadata.getAction(), (Object)exception);
        }
        return ResponseFactory.status(Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new RestErrors("An error occurred while processing the request. Check the server logs for more information.")).type("application/json;charset=UTF-8").build();
    }
}

