/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.rest.docs;

import com.atlassian.stash.rest.data.RestLink;
import com.atlassian.stash.rest.data.RestMapEntity;
import com.atlassian.stash.rest.data.RestPage;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

public class RestDocletHelper {
    public static final int PROJECT_ID = 1;
    public static final String PROJECT_KEY = "PRJ";
    public static final String PROJECT_NAME = "My Cool Project";
    public static final String PROJECT_DESCRIPTION = "The description for my cool project.";
    public static final int REPOSITORY_ID = 1;
    public static final String REPOSITORY_NAME = "My repo";
    public static final String REPOSITORY_SCM_ID = "git";
    public static final String REPOSITORY_SLUG = "my-repo";

    public static <T> RestPage<T> pageOf(T ... values) {
        return new RestPage(PageUtils.createPage(Arrays.asList(values), (boolean)true, (PageRequest)PageUtils.newRequest((int)0, (int)25)));
    }

    public static RestLink selfLink(Class<?> type) {
        return new RestLink("self", "http://link/to/" + type.getSimpleName().toLowerCase());
    }

    public static <T extends RestMapEntity> T decorate(T t, Map<String, ?> values) {
        t.putAll(values);
        return t;
    }

    public static RestMapEntity wrap(Collection<? extends RestMapEntity> entities, String wrapperName) {
        RestMapEntity wrapper = new RestMapEntity(){};
        wrapper.put(wrapperName, entities);
        return wrapper;
    }
}

