/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.rest.docs;

import com.atlassian.stash.user.DetailedUser;
import com.atlassian.stash.user.StashUserVisitor;
import com.atlassian.stash.user.UserType;
import java.util.Date;
import javax.annotation.Nonnull;

public class ExampleDetailedUser
implements DetailedUser {
    private static final Date EXAMPLE_AUTHENTICATION = new Date(1368145580548L);
    public static final ExampleDetailedUser EXAMPLE = new ExampleDetailedUser(101, "Jane Citizen", "jcitizen", UserType.NORMAL, "Stash Internal Directory", "jane@example.com", EXAMPLE_AUTHENTICATION, true, true, true, true);
    private final boolean active;
    private final boolean deletable;
    private final String directoryName;
    private final String displayName;
    private final String emailAddress;
    private final Integer id;
    private final Date lastAuthenticationTimestamp;
    private final boolean mutableDetails;
    private final boolean mutableGroups;
    private final String name;
    private final String slug;
    private final UserType type;

    @Deprecated
    public ExampleDetailedUser(Integer id, String displayName, String name, boolean active, String emailAddress, String directoryName, boolean mutableDetails, boolean mutableGroups) {
        this(id, displayName, name, UserType.NORMAL, directoryName, emailAddress, null, true, active, mutableDetails, mutableGroups);
    }

    private ExampleDetailedUser(Integer id, String displayName, String name, UserType type, String directoryName, String emailAddress, Date lastAuthenticationTimestamp, boolean deletable, boolean active, boolean mutableDetails, boolean mutableGroups) {
        this.active = active;
        this.deletable = deletable;
        this.directoryName = directoryName;
        this.displayName = displayName;
        this.emailAddress = emailAddress;
        this.id = id;
        this.lastAuthenticationTimestamp = lastAuthenticationTimestamp;
        this.mutableDetails = mutableDetails;
        this.mutableGroups = mutableGroups;
        this.name = name;
        this.slug = name;
        this.type = type;
    }

    public static ExampleDetailedUser newExample(String name) {
        int id = name.hashCode();
        String displayName = name.substring(0, 1).toUpperCase() + name.substring(1);
        String email = name + "@example.com";
        return new ExampleDetailedUser(id, displayName, name, UserType.NORMAL, "Stash Internal Directory", email, EXAMPLE_AUTHENTICATION, true, true, true, true);
    }

    public <T> T accept(@Nonnull StashUserVisitor<T> visitor) {
        return (T)visitor.visit((DetailedUser)this);
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    @Nonnull
    public String getDisplayName() {
        return this.displayName;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public Integer getId() {
        return this.id;
    }

    public Date getLastAuthenticationTimestamp() {
        return this.lastAuthenticationTimestamp;
    }

    public boolean isDeletable() {
        return this.deletable;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public String getSlug() {
        return this.slug;
    }

    @Nonnull
    public UserType getType() {
        return this.type;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isMutableDetails() {
        return this.mutableDetails;
    }

    public boolean isMutableGroups() {
        return this.mutableGroups;
    }
}

