/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.rest.data;

import com.atlassian.stash.comment.Comment;
import com.atlassian.stash.property.PropertyMap;
import com.atlassian.stash.rest.annotations.JsonSurrogate;
import com.atlassian.stash.rest.data.RestComment;
import com.atlassian.stash.rest.data.RestMapEntity;
import com.atlassian.stash.rest.data.RestPage;
import com.atlassian.stash.rest.data.RestPropertySupport;
import com.atlassian.stash.rest.data.RestStashUser;
import com.atlassian.stash.rest.data.RestTaskOperations;
import com.atlassian.stash.rest.docs.RestDocletHelper;
import com.atlassian.stash.task.Task;
import com.atlassian.stash.task.TaskAnchorType;
import com.atlassian.stash.task.TaskAnchorVisitor;
import com.atlassian.stash.task.TaskOperations;
import com.atlassian.stash.task.TaskState;
import com.atlassian.stash.user.StashUser;
import com.google.common.base.Function;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=Task.class)
public class RestTask
extends RestPropertySupport {
    public static final Function<Task, RestTask> REST_TRANSFORM = new Function<Task, RestTask>(){

        public RestTask apply(Task input) {
            return new RestTask(input);
        }
    };
    private static final TaskAnchorVisitor<RestMapEntity> ANCHOR_REST_TRANSFORM = new TaskAnchorVisitor<RestMapEntity>(){

        public RestMapEntity visit(@Nonnull Comment comment) {
            RestComment restComment = new RestComment(comment, null, null, null);
            restComment.put(RestTask.ANCHOR_TYPE, TaskAnchorType.COMMENT);
            return restComment;
        }
    };
    public static final String ANCHOR = "anchor";
    public static final String ANCHOR_TYPE = "type";
    public static final String AUTHOR = "author";
    public static final String CREATED_DATE = "createdDate";
    public static final String ID = "id";
    public static final String PERMITTED_OPERATIONS = "permittedOperations";
    public static final String STATE = "state";
    public static final String TEXT = "text";
    private static final PropertyMap SAMPLE_TASK_PROPERTY_MAP = new PropertyMap.Builder().property("diffAnchorPath", (Object)"path/to/file.txt").build();
    private static final RestMapEntity REQUEST_CREATE_TASK_ANCHOR = new RestMapEntity(){
        {
            this.put(RestTask.ID, 1L);
            this.put(RestTask.ANCHOR_TYPE, TaskAnchorType.COMMENT);
        }
    };
    private static final RestMapEntity RESPONSE_TASK_ANCHOR_WITH_DIFFERENT_CONTENT = new RestMapEntity((Map)RestComment.RESPONSE_EXAMPLE_NO_REPLY){
        {
            this.put(RestTask.ID, 5L);
            this.put(RestTask.TEXT, "This class is deprecated.  Can you please use the replacement?");
        }
    };
    public static final RestTask REQUEST_CREATE_TASK_EXAMPLE = new RestTask(REQUEST_CREATE_TASK_ANCHOR, null, null, null, null, null, "Fix the missing imports", null);
    public static final RestTask RESPONSE_CREATE_TASK_EXAMPLE = new RestTask(RestComment.RESPONSE_EXAMPLE_NO_REPLY, null, RestStashUser.RESPONSE_EXAMPLE, new RestTaskOperations(true, true, (Boolean)true), new Date(), 99L, "Fix the missing imports", null);
    public static final RestTask REQUEST_UPDATE_TASK_EXAMPLE = new RestTask(null, null, null, null, null, 99L, "Fix the missing and obsolete imports", null);
    public static final RestTask RESPONSE_UPDATE_TASK_EXAMPLE = new RestTask(RestComment.RESPONSE_EXAMPLE_NO_REPLY, SAMPLE_TASK_PROPERTY_MAP, RestStashUser.RESPONSE_EXAMPLE, new RestTaskOperations(true, true, (Boolean)true), new Date(), 99L, "Fix the missing and deprecated imports", TaskState.OPEN);
    public static final RestTask RESPONSE_GET_TASK_EXAMPLE = new RestTask(RestComment.RESPONSE_EXAMPLE_NO_REPLY, SAMPLE_TASK_PROPERTY_MAP, RestStashUser.RESPONSE_EXAMPLE, new RestTaskOperations(false, false, (Boolean)true), new Date(), 99L, "Resolve the merge conflicts", TaskState.OPEN);
    public static final RestPage<RestTask> RESPONSE_GET_PR_TASKS_EXAMPLE = RestDocletHelper.pageOf(new RestTask(RestComment.RESPONSE_EXAMPLE_NO_REPLY, SAMPLE_TASK_PROPERTY_MAP, RestStashUser.RESPONSE_EXAMPLE, new RestTaskOperations(true, true, (Boolean)true), new Date(), 98L, "Fix typos on the constructor's arguments", TaskState.OPEN), new RestTask(RESPONSE_TASK_ANCHOR_WITH_DIFFERENT_CONTENT, SAMPLE_TASK_PROPERTY_MAP, RestStashUser.RESPONSE_EXAMPLE, new RestTaskOperations(false, false, (Boolean)true), new Date(), 99L, "Remove usage of deprecated class", TaskState.RESOLVED));

    public RestTask() {
    }

    public RestTask(@Nonnull Task task) {
        this((RestMapEntity)task.getAnchor().accept(ANCHOR_REST_TRANSFORM), task.getProperties(), task.getAuthor(), null, task.getCreatedDate(), task.getId(), task.getText(), task.getState());
        TaskOperations permittedOperations = task.getPermittedOperations();
        if (permittedOperations != null) {
            this.put(PERMITTED_OPERATIONS, new RestTaskOperations(permittedOperations));
        }
    }

    private RestTask(RestMapEntity anchor, PropertyMap properties, StashUser author, RestTaskOperations taskOperations, Date createdDate, Long id, String text, TaskState state) {
        super((Map<String, Object>)properties);
        this.putIfNotEmpty(ANCHOR, anchor);
        this.putIfNotEmpty(AUTHOR, author == null ? Collections.emptyMap() : new RestStashUser(author));
        this.putIfNotNull(CREATED_DATE, createdDate);
        this.putIfNotNull(ID, id);
        this.putIfNotEmpty(PERMITTED_OPERATIONS, taskOperations);
        this.putIfNotNull(TEXT, text);
        this.putIfNotNull(STATE, state);
    }

    public long getAnchorId() {
        return this.getAnchorMap().getLongProperty(ID);
    }

    public TaskAnchorType getAnchorType() {
        return this.getAnchorMap().getEnumProperty(ANCHOR_TYPE, TaskAnchorType.class);
    }

    @Nullable
    public RestStashUser getAuthor() {
        return RestStashUser.valueOf(this.get(AUTHOR));
    }

    @Nullable
    public Date getCreatedDate() {
        long createdDate = this.getLongProperty(CREATED_DATE);
        return createdDate == -1L ? null : new Date(createdDate);
    }

    @Nullable
    public Long getId() {
        long id = this.getLongProperty(ID);
        return id == -1L ? null : Long.valueOf(id);
    }

    @Nullable
    public TaskState getState() {
        return this.get(STATE) == null ? null : this.getEnumProperty(STATE, TaskState.class);
    }

    @Nullable
    public String getText() {
        return this.getStringProperty(TEXT);
    }

    private RestMapEntity getAnchorMap() {
        final Map anchorMap = (Map)this.get(ANCHOR);
        return new RestMapEntity(){
            {
                if (anchorMap != null) {
                    this.putAll(anchorMap);
                }
            }
        };
    }
}

