/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.rest.data;

import com.atlassian.stash.project.PersonalProject;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.project.ProjectType;
import com.atlassian.stash.project.ProjectVisitor;
import com.atlassian.stash.rest.annotations.JsonSurrogate;
import com.atlassian.stash.rest.data.AvatarAware;
import com.atlassian.stash.rest.data.RestLink;
import com.atlassian.stash.rest.data.RestLinkedMapEntity;
import com.atlassian.stash.rest.data.RestPage;
import com.atlassian.stash.rest.data.RestPersonalProject;
import com.atlassian.stash.rest.data.RestRelatedLinks;
import com.atlassian.stash.rest.docs.RestDocletHelper;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=Project.class)
public class RestProject
extends RestLinkedMapEntity
implements AvatarAware,
Project {
    private static final String AVATAR = "avatar";
    private static final String DESCRIPTION = "description";
    private static final String ID = "id";
    private static final String KEY = "key";
    private static final String NAME = "name";
    private static final String PUBLIC = "public";
    private static final String TYPE = "type";
    public static final Function<Project, RestProject> REST_TRANSFORM = new Function<Project, RestProject>(){

        public RestProject apply(Project project) {
            return RestProject.fromProject(project);
        }
    };
    public static final ProjectVisitor<RestProject> TRANSFORM_VISITOR = new ProjectVisitor<RestProject>(){

        public RestProject visit(@Nonnull Project project) {
            return new RestProject(project);
        }

        public RestProject visit(@Nonnull PersonalProject project) {
            return new RestPersonalProject(project);
        }
    };
    private static final ImmutableMap<String, String> EXAMPLE_AVATAR_PARAM = ImmutableMap.of((Object)"avatar", (Object)"data:image/png;base64,<base64-encoded-image-data>");
    public static final RestProject REQUEST_EXAMPLE = RestDocletHelper.decorate(new RestProject(null, "PRJ", "My Cool Project", "The description for my cool project.", null, null, null, null), EXAMPLE_AVATAR_PARAM);
    public static final RestProject REQUEST_EXAMPLE_KEY_ONLY = new RestProject(null, "PRJ", null, null, null, null);
    public static final RestProject RESPONSE_EXAMPLE_PERSONAL = new RestProject(2, "~JDOE", "John Doe", null, ProjectType.PERSONAL, null, RestDocletHelper.selfLink(Project.class), RestDocletHelper.selfLink(Project.class).toSingleRelatedLink());
    public static final RestProject RESPONSE_EXAMPLE = new RestProject(1, "PRJ", "My Cool Project", "The description for my cool project.", ProjectType.NORMAL, true, RestDocletHelper.selfLink(Project.class), RestDocletHelper.selfLink(Project.class).toSingleRelatedLink());
    public static final RestPage<RestProject> PAGE_EXAMPLE = RestDocletHelper.pageOf(RESPONSE_EXAMPLE);

    public RestProject() {
    }

    public RestProject(Project project) {
        this(project.getId(), project.getKey(), project.getName(), project.getDescription(), project.getType(), project.isPublic());
    }

    RestProject(Integer id, String key, String name, String description, ProjectType type, Boolean publiclyAccessible) {
        this.putIfNotNull(KEY, key);
        this.putIfNotNull(ID, id);
        this.putIfNotNull(NAME, name);
        this.putIfNotNull(DESCRIPTION, description);
        this.putIfNotNull(PUBLIC, publiclyAccessible);
        if (type != null) {
            this.put(TYPE, type.name());
        }
    }

    private RestProject(Integer id, String key, String name, String description, ProjectType type, Boolean publiclyAccessible, RestLink selfLink, RestRelatedLinks links) {
        this(id, key, name, description, type, publiclyAccessible);
        this.setSelfLink(selfLink);
        this.setLinks(links);
    }

    private RestProject(Map<String, Object> values) {
        super(values);
    }

    public <T> T accept(@Nonnull ProjectVisitor<T> visitor) {
        return (T)visitor.visit((Project)this);
    }

    public String getAvatar() {
        return StringUtils.trimToNull((String)this.getStringProperty(AVATAR));
    }

    public String getDescription() {
        return this.getStringProperty(DESCRIPTION);
    }

    public Integer getId() {
        return this.getIntProperty(ID);
    }

    public String getKey() {
        return this.getStringProperty(KEY);
    }

    public String getName() {
        return this.getStringProperty(NAME);
    }

    @Nonnull
    public ProjectType getType() {
        return this.getEnumProperty(TYPE, ProjectType.class);
    }

    public boolean hasAvatar() {
        return StringUtils.isNotBlank((String)this.getStringProperty(AVATAR));
    }

    public boolean hasPublic() {
        return this.get(PUBLIC) != null;
    }

    public boolean isPublic() {
        return this.getBoolProperty(PUBLIC);
    }

    @Override
    public void setAvatarUrl(String url) {
        this.put("avatarUrl", url);
    }

    public static RestProject fromProject(Project project) {
        if (project == null) {
            return null;
        }
        return (RestProject)project.accept(TRANSFORM_VISITOR);
    }

    public static RestProject valueOf(Object value) {
        if (value instanceof RestProject) {
            return (RestProject)value;
        }
        if (value instanceof Map) {
            return new RestProject((Map)value);
        }
        return null;
    }
}

