/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.rest.data;

import com.atlassian.stash.i18n.KeyedMessage;
import com.atlassian.stash.pull.InvalidPullRequestReviewersException;
import com.atlassian.stash.rest.annotations.JsonSurrogate;
import com.atlassian.stash.rest.data.RestErrorMessage;
import com.atlassian.stash.rest.data.RestPullRequestParticipant;
import com.atlassian.stash.rest.data.RestStashUser;
import com.atlassian.stash.user.StashUser;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=InvalidPullRequestReviewersException.class)
public class RestInvalidPullRequestReviewersErrorMessage
extends RestErrorMessage {
    public static final String REVIEWER_ERRORS = "reviewerErrors";
    public static final String VALID_REVIEWERS = "validReviewers";

    public RestInvalidPullRequestReviewersErrorMessage(InvalidPullRequestReviewersException exception) {
        super("reviewers", exception.getLocalizedMessage(), exception.getClass().getCanonicalName());
        this.put(REVIEWER_ERRORS, ImmutableList.copyOf((Collection)Collections2.transform(exception.getReviewerErrors().entrySet(), (Function)new Function<Map.Entry<String, KeyedMessage>, RestErrorMessage>(){

            public RestErrorMessage apply(@Nullable Map.Entry<String, KeyedMessage> entry) {
                return new RestErrorMessage(entry.getKey(), entry.getValue().getLocalisedMessage());
            }
        })));
        this.put(VALID_REVIEWERS, ImmutableList.copyOf((Collection)Collections2.transform((Collection)exception.getValidReviewers(), (Function)new Function<StashUser, RestPullRequestParticipant>(){

            public RestPullRequestParticipant apply(@Nullable StashUser user) {
                ImmutableMap participantMap = ImmutableMap.of((Object)"user", (Object)new RestStashUser(user));
                return new RestPullRequestParticipant((Map<String, Object>)participantMap);
            }
        })));
    }

    public Collection<RestErrorMessage> getReviewerErrors() {
        return (Collection)this.get(REVIEWER_ERRORS);
    }

    public Collection<RestPullRequestParticipant> getValidReviewers() {
        return (Collection)this.get(VALID_REVIEWERS);
    }
}

