/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.rest.data;

import com.atlassian.stash.content.ConflictMarker;
import com.atlassian.stash.content.DiffLine;
import com.atlassian.stash.rest.annotations.JsonSurrogate;
import com.atlassian.stash.rest.data.RestMapEntity;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=DiffLine.class)
public class RestDiffLine
extends RestMapEntity {
    public static final Function<DiffLine, RestDiffLine> REST_TRANSFORM = new Function<DiffLine, RestDiffLine>(){

        public RestDiffLine apply(DiffLine line) {
            return new RestDiffLine(line);
        }
    };
    public static final RestDiffLine SOURCE_EXAMPLE = new RestDiffLine(1, 1, "import sys", false, null, null, false);
    public static final RestDiffLine DESTINATION_EXAMPLE = new RestDiffLine(2, 1, "import re", false, null, null, false);
    public static final RestDiffLine DESTINATION_EXAMPLE_WITH_COMMENTS = new RestDiffLine(2, 1, "import re", true, ConflictMarker.OURS, Lists.newArrayList((Object[])new Long[]{1L}), false);
    public static final RestDiffLine DESTINATION_2_EXAMPLE = new RestDiffLine(3, 2, "import os", false, null, null, false);

    public RestDiffLine() {
    }

    public RestDiffLine(DiffLine line) {
        this(line.getSource(), line.getDestination(), line.getLine(), line.isConflicting(), line.getConflictMarker(), line.getCommentIds(), line.isTruncated());
    }

    private RestDiffLine(int source, int destination, String line, boolean conflicted, ConflictMarker conflictMarker, List<Long> commentIds, boolean truncated) {
        this.putIfNotNull("destination", destination);
        this.putIfNotNull("source", source);
        this.putIfNotNull("line", line);
        this.putIfNotNull("truncated", truncated);
        if (conflicted) {
            this.put("conflictMarker", conflictMarker);
        }
        this.putIfNotEmpty("commentIds", (Collection<?>)commentIds);
    }
}

