/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.rest.data;

import com.atlassian.stash.content.Change;
import com.atlassian.stash.content.ChangeType;
import com.atlassian.stash.content.ContentTreeNode;
import com.atlassian.stash.nav.NavBuilder;
import com.atlassian.stash.property.PropertyMap;
import com.atlassian.stash.rest.annotations.JsonSurrogate;
import com.atlassian.stash.rest.data.RestConflict;
import com.atlassian.stash.rest.data.RestLink;
import com.atlassian.stash.rest.data.RestLinkedMapEntity;
import com.atlassian.stash.rest.data.RestPage;
import com.atlassian.stash.rest.data.RestPath;
import com.atlassian.stash.rest.data.RestRelatedLinks;
import com.atlassian.stash.rest.docs.RestDocletHelper;
import com.google.common.base.Function;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=Change.class)
public class RestChange
extends RestLinkedMapEntity {
    public static final Function<Change, RestChange> REST_TRANSFORM = new Function<Change, RestChange>(){

        public RestChange apply(Change change) {
            return change == null ? null : new RestChange(change);
        }
    };
    public static final RestChange EXAMPLE = new RestChange("abcdef0123abcdef4567abcdef8987abcdef6543", "bcdef0123abcdef4567abcdef8987abcdef6543a", RestPath.fromPath("new/path/to/file.txt"), Boolean.FALSE, RestPath.EXAMPLE, Boolean.FALSE, ChangeType.MOVE, ContentTreeNode.Type.FILE, 98, null, RestDocletHelper.selfLink(RestChange.class), null, null, RestDocletHelper.selfLink(RestChange.class).toSingleRelatedLink());
    public static final RestPage<RestChange> PAGE_EXAMPLE = RestDocletHelper.pageOf(EXAMPLE);

    public RestChange(Change change) {
        this(change, null);
    }

    public RestChange(Change change, NavBuilder.Changeset changesetNav) {
        this(change.getContentId(), change.getFromContentId(), RestPath.fromPath(change.getPath()), change.getExecutable(), RestPath.fromPath(change.getSrcPath()), change.getSrcExecutable(), change.getType(), change.getNodeType(), change.getPercentUnchanged(), RestConflict.fromConflict(change.getConflict()), changesetNav == null ? null : new RestLink("self", changesetNav.change(change.getPath()).buildRelNoContext()), (Map<String, Set<String>>)change.getAttributes(), change.getProperties(), changesetNav == null ? null : new RestLink("self", changesetNav.change(change.getPath()).buildAbsolute()).toSingleRelatedLink());
    }

    private RestChange(String contentId, String fromContentId, RestPath path, Boolean executable, RestPath srcPath, Boolean srcExecutable, ChangeType type, ContentTreeNode.Type nodeType, int percentUnchanged, RestConflict conflict, RestLink link, Map<String, Set<String>> attributes, PropertyMap properties, RestRelatedLinks relatedLinks) {
        this.put("contentId", contentId);
        this.put("fromContentId", fromContentId);
        this.put("path", path);
        this.putIfNotNull("executable", executable);
        this.put("percentUnchanged", percentUnchanged);
        this.put("type", type);
        this.put("nodeType", nodeType);
        this.putIfNotNull("srcPath", srcPath);
        this.putIfNotNull("srcExecutable", srcExecutable);
        this.putIfNotNull("conflict", conflict);
        this.setSelfLink(link);
        this.setLinks(relatedLinks);
        this.putIfNotEmpty("attributes", attributes);
        this.putIfNotEmpty("properties", (Map<?, ?>)properties);
    }

    public static Function<Change, RestChange> transform() {
        return REST_TRANSFORM;
    }

    public static Function<Change, RestChange> transform(NavBuilder.Changeset nav) {
        if (nav == null) {
            return RestChange.transform();
        }
        return new FullRestTransform(nav);
    }

    private static class FullRestTransform
    implements Function<Change, RestChange> {
        private final NavBuilder.Changeset nav;

        private FullRestTransform(NavBuilder.Changeset nav) {
            this.nav = nav;
        }

        public RestChange apply(Change change) {
            return new RestChange(change, this.nav);
        }
    }
}

