/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.spring;

import com.atlassian.stash.internal.spring.TransactionSynchronizer;
import javax.annotation.Nonnull;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Component(value="transactionSynchronizer")
public class DefaultTransactionSynchronizer
implements TransactionSynchronizer {
    @Override
    public boolean isAvailable() {
        return TransactionSynchronizationManager.isActualTransactionActive() && TransactionSynchronizationManager.isSynchronizationActive();
    }

    @Override
    public boolean register(@Nonnull TransactionSynchronization synchronization) {
        if (this.isAvailable()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)synchronization);
            return true;
        }
        return false;
    }
}

