/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.profiles;

import com.atlassian.stash.internal.profiles.Dev;
import com.atlassian.stash.internal.profiles.Production;
import com.atlassian.stash.util.DevModeUtils;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class DevModeCondition
implements Condition {
    public static final String PROFILE_DEV = "dev";
    public static final String PROFILE_PROD = "production";
    public static final String PROP_PROFILES = "stash.spring.profiles";

    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        return metadata.isAnnotated(Dev.class.getName()) && DevModeCondition.chooseProfiles().contains(PROFILE_DEV) || metadata.isAnnotated(Production.class.getName()) && DevModeCondition.chooseProfiles().contains(PROFILE_PROD);
    }

    private static Set<String> chooseProfiles() {
        String property = System.getProperty(PROP_PROFILES);
        if (StringUtils.isBlank((CharSequence)property)) {
            return DevModeUtils.isEnabled() ? Collections.singleton(PROFILE_DEV) : Collections.singleton(PROFILE_PROD);
        }
        return ImmutableSet.copyOf((Object[])property.split(","));
    }
}

