/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin.web.fragments;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.map.ObjectMapper;

public class PageDataUtils {
    private static final JsonFactory jsonFactory = new ObjectMapper().getJsonFactory();

    private PageDataUtils() {
    }

    public static void appendScriptTag(Writer writer, Map<String, Map<String, Object>> pageDataByContext) throws IOException {
        if (pageDataByContext.isEmpty()) {
            return;
        }
        writer.append("<script>(function(loader) {");
        StringWriter sw = new StringWriter();
        for (Map.Entry<String, Map<String, Object>> contextData : pageDataByContext.entrySet()) {
            String contextId = contextData.getKey();
            Map<String, Object> dataByPluginKey = contextData.getValue();
            sw.append("loader.load(").append("'").append(StringEscapeUtils.escapeJavaScript((String)contextId)).append("', ");
            PageDataUtils.writeJSONMap(sw, dataByPluginKey);
            sw.append(");");
        }
        writer.append(sw.toString().replaceAll("<", "\\u003C"));
        writer.append("}(_PageDataPlugin));</script>");
    }

    private static void writeJSONMap(Writer writer, Map<String, Object> map) throws IOException {
        jsonFactory.createJsonGenerator(writer).writeObject(map);
    }
}

