/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin.web.fragments;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.stash.internal.plugin.web.fragments.PageDataProviderModuleDescriptor;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Element;

public class DefaultPageDataProviderModuleDescriptor
extends AbstractModuleDescriptor<ContextProvider>
implements PageDataProviderModuleDescriptor<ContextProvider> {
    public static final String XML_ELEMENT_NAME = "page-data-provider";
    private Set<String> contexts;
    private Map<String, String> params;
    private ContextProvider module;

    public DefaultPageDataProviderModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.params = this.parseParams(element);
        this.contexts = this.parseContexts(element);
    }

    public ContextProvider getModule() {
        return this.getPageDataProvider();
    }

    @Override
    public ContextProvider getPageDataProvider() {
        return this.module;
    }

    public void enabled() {
        super.enabled();
        this.module = (ContextProvider)this.moduleFactory.createModule(this.moduleClassName, (ModuleDescriptor)this);
        this.module.init(this.params);
    }

    @Override
    public Set<String> getPageDataContexts() {
        return this.contexts;
    }

    private Set<String> parseContexts(Element root) {
        return Sets.newHashSet((Iterable)Lists.transform((List)root.elements("context"), (Function)new Function<Object, String>(){

            public String apply(Object context) {
                return ((Element)context).getTextTrim();
            }
        }));
    }

    private Map<String, String> parseParams(Element root) throws PluginParseException {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Object o : root.elements("param")) {
            Element param = (Element)o;
            builder.put((Object)param.attributeValue("name"), (Object)param.attributeValue("value"));
        }
        try {
            return builder.build();
        }
        catch (IllegalArgumentException e) {
            throw new PluginParseException("Duplicate params found", (Throwable)e);
        }
    }
}

