/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.plugin.osgi.container.PackageScannerConfiguration;
import com.atlassian.plugin.osgi.container.impl.DefaultPackageScannerConfiguration;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=PackageScannerConfiguration.class)
@Component
public class StashPackageScannerConfiguration
extends DefaultPackageScannerConfiguration {
    private static final String EXPORT_PACKAGES = "osgi-export-packages.properties";
    private static final String EXPORTED_VERSIONS = "library-export-versions.properties";
    private static final String PRIVATE_PACKAGES = "osgi-private-packages.properties";
    private static final Logger log = LoggerFactory.getLogger(StashPackageScannerConfiguration.class);

    public StashPackageScannerConfiguration() {
        super(StashPackageScannerConfiguration.determineVersion());
        ArrayList<String> exportPackages = new ArrayList<String>(StashPackageScannerConfiguration.loadProperties(EXPORT_PACKAGES).stringPropertyNames());
        this.setPackageIncludes(exportPackages);
        ArrayList<String> privatePackages = new ArrayList<String>(StashPackageScannerConfiguration.loadProperties(PRIVATE_PACKAGES).stringPropertyNames());
        this.setPackageExcludes(privatePackages);
        Properties exports = StashPackageScannerConfiguration.loadProperties(EXPORTED_VERSIONS);
        this.setPackageVersions((Map)Maps.fromProperties((Properties)exports));
    }

    private static String determineVersion() {
        Properties properties = StashPackageScannerConfiguration.loadProperties("META-INF/maven/com.atlassian.plugins/atlassian-plugins-core/pom.properties");
        return properties.getProperty("version");
    }

    private static Properties loadProperties(String resourceName) {
        Properties properties = new Properties();
        try (InputStream in = StashPackageScannerConfiguration.class.getClassLoader().getResourceAsStream(resourceName);){
            properties.load(in);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return properties;
    }
}

