/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.plugin.servlet.ContentTypeResolver;
import com.atlassian.plugin.spring.AvailableToPlugins;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import javax.activation.FileTypeMap;
import javax.activation.MimetypesFileTypeMap;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=ContentTypeResolver.class)
@Component(value="contentTypeResolver")
public class SimpleContentTypeResolver
implements ContentTypeResolver {
    private final FileTypeMap fileTypes;

    public SimpleContentTypeResolver() throws IOException {
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream("mime.types");){
            this.fileTypes = new MimetypesFileTypeMap(in);
        }
    }

    public String getContentType(String requestUrl) {
        String filename = requestUrl.substring(requestUrl.lastIndexOf(47));
        return this.fileTypes.getContentType(filename.toLowerCase(Locale.US));
    }
}

