/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.locale;

import com.atlassian.stash.internal.locale.InternalLocaleService;
import com.atlassian.stash.internal.user.InternalDetailedUser;
import com.atlassian.stash.internal.user.InternalNormalUser;
import com.atlassian.stash.internal.user.InternalStashUser;
import com.atlassian.stash.user.AbstractStashUserVisitor;
import com.atlassian.stash.user.DetailedUser;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.StashUserVisitor;
import com.google.common.base.Objects;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;

@Component(value="localeService")
public class DefaultLocaleService
implements InternalLocaleService {
    private final StashAuthenticationContext authenticationContext;

    @Autowired
    public DefaultLocaleService(StashAuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    @Override
    @Nonnull
    public Locale getLocale() {
        InternalNormalUser user = DefaultLocaleService.getNormalUser(this.authenticationContext.getCurrentUser());
        return (Locale)Objects.firstNonNull((Object)(user != null ? user.getLocale() : null), (Object)LocaleContextHolder.getLocale());
    }

    public static InternalNormalUser getNormalUser(StashUser user) {
        InternalStashUser internalUser = user != null ? (InternalStashUser)user.accept((StashUserVisitor)new AbstractStashUserVisitor<InternalStashUser>(){

            public InternalStashUser visit(@Nonnull StashUser user) {
                return user instanceof InternalStashUser ? (InternalStashUser)user : null;
            }

            public InternalStashUser visit(@Nonnull DetailedUser user) {
                return ((InternalDetailedUser)user).getDelegate();
            }
        }) : null;
        return internalUser != null ? InternalNormalUser.TO_NORMAL_USER.apply(internalUser) : null;
    }
}

