/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.home;

import com.atlassian.stash.internal.home.AtomicFileMover;
import com.atlassian.stash.internal.home.DefaultHomeSubdirectoryResolver;
import com.atlassian.stash.internal.home.HomeDirectoryDetails;
import com.atlassian.stash.internal.home.HomeDirectoryMigrationException;
import com.atlassian.stash.internal.home.HomeFileMover;
import com.atlassian.stash.internal.home.HomeSubdirectoryResolver;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HomeDirectoryMigration {
    private static final List<String> FILES_AND_DIRECTORIES_TO_MOVE = ImmutableList.of((Object)"config", (Object)"data", (Object)"plugins/installed-plugins", (Object)"stash-config.properties");
    private static final List<String> FILES_AND_DIRECTORIES_TO_VALIDATE = new ImmutableList.Builder().addAll(FILES_AND_DIRECTORIES_TO_MOVE).add((Object)"data/repositories").build();
    private static final Logger log = LoggerFactory.getLogger(HomeDirectoryMigration.class);
    private final HomeFileMover homeFileMover;
    private final HomeDirectoryDetails homeDirectoryDetails;
    private final HomeSubdirectoryResolver homeSubdirectoryResolver;

    public HomeDirectoryMigration(HomeDirectoryDetails homeDirectoryDetails) {
        this(homeDirectoryDetails, new HomeFileMover(new AtomicFileMover()), new DefaultHomeSubdirectoryResolver());
    }

    public HomeDirectoryMigration(HomeDirectoryDetails homeDirectoryDetails, HomeFileMover homeFileMover, HomeSubdirectoryResolver homeSubdirectoryResolver) {
        this.homeDirectoryDetails = homeDirectoryDetails;
        this.homeFileMover = homeFileMover;
        this.homeSubdirectoryResolver = homeSubdirectoryResolver;
    }

    public void perform() {
        File homeDir = this.homeDirectoryDetails.getHome();
        File sharedHomeDir = this.homeDirectoryDetails.getSharedHome();
        this.validate(homeDir, sharedHomeDir);
        for (String fileToMove : FILES_AND_DIRECTORIES_TO_MOVE) {
            this.performMove(homeDir, sharedHomeDir, fileToMove);
        }
    }

    private static void checkHomeDirectory(File directory, String type) {
        if (!directory.exists()) {
            throw new HomeDirectoryMigrationException(type + " directory [" + directory + "] does not exist.");
        }
        if (!directory.isDirectory()) {
            throw new HomeDirectoryMigrationException(type + " directory [" + directory + "] is not a directory.");
        }
        if (SystemUtils.IS_OS_WINDOWS && directory.getPath().length() > 200) {
            log.warn("The {} Directory is close to the Windows max path length ({}). This may prevent merging pull requests in the web UI. See {} for more details.", new Object[]{type, directory.getPath().length(), "https://confluence.atlassian.com/x/04oMEg"});
        }
    }

    private static FileStore getFileStore(File file) {
        try {
            return Files.getFileStore(file.toPath());
        }
        catch (IOException | SecurityException e) {
            return null;
        }
    }

    private void performMove(File sourceParentDir, File targetParentDir, String name) {
        File sourceFile = new File(sourceParentDir, name);
        File targetFile = new File(targetParentDir, name);
        try {
            this.homeFileMover.move(sourceFile, targetFile);
        }
        catch (IOException exc) {
            throw new HomeDirectoryMigrationException("Could not move '" + sourceFile.getPath() + "' to '" + targetFile.getPath() + "'.", exc);
        }
    }

    private void raiseValidationErrorsIfAny(List<String> validationErrors) {
        if (validationErrors.size() > 0) {
            throw new HomeDirectoryMigrationException(validationErrors);
        }
    }

    private void validate(File homeDir, File sharedHomeDir) {
        HomeDirectoryMigration.checkHomeDirectory(homeDir, "Home");
        HomeDirectoryMigration.checkHomeDirectory(sharedHomeDir, "Shared Home");
        this.homeSubdirectoryResolver.getHomeSubdirectoryOverride("config");
        this.homeSubdirectoryResolver.getHomeSubdirectoryOverride("data");
        this.homeSubdirectoryResolver.getHomeSubdirectoryOverride("plugins");
        ArrayList<String> validationErrors = new ArrayList<String>();
        for (String fileToValidate : FILES_AND_DIRECTORIES_TO_VALIDATE) {
            this.validateMove(homeDir, sharedHomeDir, fileToValidate, validationErrors);
        }
        this.raiseValidationErrorsIfAny(validationErrors);
    }

    private void validateMove(File sourceParentDir, File targetParentDir, String name, List<String> validationErrors) {
        File source = new File(sourceParentDir, name);
        File target = new File(targetParentDir, name);
        String sourcePath = source.getAbsolutePath();
        String targetPath = target.getAbsolutePath();
        if (source.exists() && target.exists()) {
            validationErrors.add("Both old '" + sourcePath + "' and new '" + targetPath + "' exist.");
        }
        FileStore sourceFileStore = HomeDirectoryMigration.getFileStore(source);
        FileStore targetParentFileStore = HomeDirectoryMigration.getFileStore(targetParentDir);
        if (sourceFileStore != null && !sourceFileStore.equals(targetParentFileStore)) {
            validationErrors.add("Can't move '" + sourcePath + "' to '" + targetPath + "' automatically, as it is on a different volume or mount point.\n" + "Volume for '" + sourcePath + "': " + sourceFileStore.toString() + "\n" + "Volume for '" + targetParentDir.getAbsolutePath() + "': " + targetParentFileStore.toString());
        }
        try {
            Path sourceSymbolicLink = Files.readSymbolicLink(source.toPath());
            if (!sourceSymbolicLink.isAbsolute()) {
                validationErrors.add("Can't move '" + sourcePath + "' to '" + targetPath + "' automatically, as it is a relative symbolic link to '" + sourceSymbolicLink.toString() + "'.");
            }
        }
        catch (IOException | SecurityException | UnsupportedOperationException e) {
            // empty catch block
        }
    }
}

