/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.home;

import com.atlassian.stash.internal.home.DefaultEnvironmentVariableResolver;
import com.atlassian.stash.internal.home.EnvironmentVariableResolver;
import com.atlassian.stash.internal.home.HomeSubdirectoryResolver;
import com.atlassian.stash.internal.home.UnsupportedDirectoryOverrideException;
import com.atlassian.stash.util.FileUtils;
import java.io.File;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class DefaultHomeSubdirectoryResolver
implements HomeSubdirectoryResolver {
    private static final String SYSTEM_PROPERTY_PREFIX = "stash.home.";
    private static final String ENVIRONMENT_VARIABLE_PREFIX = "STASH_HOME_";
    private final EnvironmentVariableResolver environmentVariableResolver;

    public DefaultHomeSubdirectoryResolver() {
        this(new DefaultEnvironmentVariableResolver());
    }

    public DefaultHomeSubdirectoryResolver(EnvironmentVariableResolver environmentVariableResolver) {
        this.environmentVariableResolver = environmentVariableResolver;
    }

    @Override
    @Nonnull
    public File getHomeSubdirectory(@Nonnull File parent, @Nonnull String name) {
        String override = this.getHomeSubdirectoryOverride(name);
        return override == null ? FileUtils.mkdir((File)parent, (String)name) : FileUtils.mkdir((String)override);
    }

    @Override
    public String getHomeSubdirectoryOverride(@Nonnull String name) {
        boolean isNotTmp = !name.equals("tmp");
        String envVariableName = ENVIRONMENT_VARIABLE_PREFIX + name.toUpperCase();
        String envVariableValue = this.environmentVariableResolver.getValue(envVariableName);
        if (StringUtils.isNotEmpty((String)envVariableValue) && isNotTmp) {
            throw new UnsupportedDirectoryOverrideException("Overriding %s directory location using %s environment variable is no longer supported", name, envVariableName);
        }
        String propertyName = SYSTEM_PROPERTY_PREFIX + name;
        String propertyValue = System.getProperty(propertyName, envVariableValue);
        if (StringUtils.isNotEmpty((String)propertyValue) && isNotTmp) {
            throw new UnsupportedDirectoryOverrideException("Overriding %s directory location using %s system property is no longer supported", name, propertyName);
        }
        return propertyValue;
    }
}

