/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.event;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.event.config.ListenerHandlersConfiguration;
import com.atlassian.event.spi.EventDispatcher;
import com.atlassian.event.spi.ListenerHandler;
import com.atlassian.event.spi.ListenerInvoker;
import com.atlassian.plugin.util.ClassUtils;
import com.atlassian.stash.internal.event.IdentityInvokerTransformer;
import com.atlassian.stash.internal.event.InvokerTransformer;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.MapMaker;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LockFreeEventPublisher
implements EventPublisher {
    private final InvokerBuilder invokerBuilder;
    private final Publisher publisher;
    private final Listeners listeners = new Listeners();

    public LockFreeEventPublisher(EventDispatcher eventDispatcher, ListenerHandlersConfiguration listenerHandlersConfiguration, InvokerTransformer transformer) {
        this.invokerBuilder = new InvokerBuilder(((ListenerHandlersConfiguration)Preconditions.checkNotNull((Object)listenerHandlersConfiguration)).getListenerHandlers());
        this.publisher = new Publisher(eventDispatcher, this.listeners, transformer);
    }

    public LockFreeEventPublisher(EventDispatcher eventDispatcher, ListenerHandlersConfiguration listenerHandlersConfiguration) {
        this(eventDispatcher, listenerHandlersConfiguration, new IdentityInvokerTransformer());
    }

    public void publish(@Nonnull Object event) {
        Preconditions.checkNotNull((Object)event);
        this.publisher.dispatch(event);
    }

    public void register(@Nonnull Object listener) {
        Preconditions.checkNotNull((Object)listener);
        this.listeners.register(listener, this.invokerBuilder.build(listener));
    }

    public void unregister(@Nonnull Object listener) {
        Preconditions.checkNotNull((Object)listener);
        this.listeners.remove(listener);
    }

    public void unregisterAll() {
        this.listeners.clear();
    }

    static final class InvokerBuilder {
        private final Iterable<ListenerHandler> listenerHandlers;

        InvokerBuilder(@Nonnull Iterable<ListenerHandler> listenerHandlers) {
            this.listenerHandlers = (Iterable)Preconditions.checkNotNull(listenerHandlers);
        }

        Iterable<ListenerInvoker> build(Object listener) throws IllegalArgumentException {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (ListenerHandler listenerHandler : this.listenerHandlers) {
                builder.addAll((Iterable)listenerHandler.getInvokers(listener));
            }
            ImmutableList invokers = builder.build();
            if (invokers.isEmpty()) {
                throw new IllegalArgumentException("No listener invokers were found for listener <" + listener + ">");
            }
            return invokers;
        }
    }

    static final class Publisher {
        private static final Logger log = LoggerFactory.getLogger(Publisher.class);
        private final Listeners listeners;
        private final EventDispatcher dispatcher;
        private final InvokerTransformer transformer;
        private final Function<Class, Iterable<ListenerInvoker>> eventClassToInvokersTransformer = new Function<Class, Iterable<ListenerInvoker>>(){

            public Iterable<ListenerInvoker> apply(Class eventClass) {
                return Publisher.this.listeners.get(eventClass);
            }
        };

        Publisher(EventDispatcher dispatcher, Listeners listeners, InvokerTransformer transformer) {
            this.dispatcher = (EventDispatcher)Preconditions.checkNotNull((Object)dispatcher);
            this.listeners = (Listeners)Preconditions.checkNotNull((Object)listeners);
            this.transformer = (InvokerTransformer)Preconditions.checkNotNull((Object)transformer);
        }

        public void dispatch(Object event) {
            Iterable<ListenerInvoker> invokers = this.getInvokers(event);
            try {
                invokers = this.transformer.transformAll(invokers, event);
            }
            catch (Exception e) {
                log.error("Exception while transforming invokers. Dispatching original invokers instead.", (Throwable)e);
            }
            for (ListenerInvoker invoker : invokers) {
                try {
                    this.dispatcher.dispatch(invoker, event);
                }
                catch (Exception e) {
                    log.error("Exception while dispatching to invoker '" + invoker + "' for event '" + event + "'", (Throwable)e);
                }
            }
        }

        Iterable<ListenerInvoker> getInvokers(Object event) {
            Set allEventTypes = ClassUtils.findAllTypes(event.getClass());
            return ImmutableSet.copyOf((Iterable)Iterables.concat((Iterable)Collections2.transform((Collection)allEventTypes, this.eventClassToInvokersTransformer)));
        }
    }

    static final class Invokers {
        private final ConcurrentMap<Object, ListenerInvoker> listeners = new MapMaker().weakKeys().makeMap();

        Invokers() {
        }

        Iterable<ListenerInvoker> all() {
            return this.listeners.values();
        }

        public void remove(Object key) {
            this.listeners.remove(key);
        }

        public void add(Object key, ListenerInvoker invoker) {
            this.listeners.put(key, invoker);
        }
    }

    static final class Listeners {
        private final ConcurrentMap<Class<?>, Invokers> invokers = new MapMaker().weakKeys().makeComputingMap(new Function<Class<?>, Invokers>(){

            public Invokers apply(Class<?> from) {
                return new Invokers();
            }
        });

        Listeners() {
        }

        void register(Object listener, Iterable<ListenerInvoker> invokers) {
            for (ListenerInvoker invoker : invokers) {
                this.register(listener, invoker);
            }
        }

        private void register(Object listener, ListenerInvoker invoker) {
            if (invoker.getSupportedEventTypes().isEmpty()) {
                ((Invokers)this.invokers.get(Object.class)).add(listener, invoker);
            } else {
                for (Class eventClass : invoker.getSupportedEventTypes()) {
                    ((Invokers)this.invokers.get(eventClass)).add(listener, invoker);
                }
            }
        }

        void remove(Object listener) {
            for (Invokers entry : this.invokers.values()) {
                entry.remove(listener);
            }
        }

        void clear() {
            this.invokers.clear();
        }

        public Iterable<ListenerInvoker> get(Class<?> eventClass) {
            return ((Invokers)this.invokers.get(eventClass)).all();
        }
    }
}

