/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.validation;

import com.atlassian.plugin.module.ContainerAccessor;
import com.atlassian.plugin.osgi.spring.DefaultSpringContainerAccessor;
import com.google.common.base.Preconditions;
import javax.validation.ConstraintValidator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.validation.beanvalidation.SpringConstraintValidatorFactory;

@Component(value="constraintValidatorFactory")
public class PluginAwareConstraintValidatorFactory
extends SpringConstraintValidatorFactory {
    private static final Logger log = LoggerFactory.getLogger(PluginAwareConstraintValidatorFactory.class);

    @Autowired
    public PluginAwareConstraintValidatorFactory(AutowireCapableBeanFactory beanFactory) {
        super(beanFactory);
    }

    public <T extends ConstraintValidator<?, ?>> T getInstance(Class<T> key) {
        if (key.getClassLoader() instanceof BundleReference) {
            try {
                ContainerAccessor containerAccessor = this.createContainerAccessor(((BundleReference)key.getClassLoader()).getBundle());
                return (T)((ConstraintValidator)containerAccessor.createBean(key));
            }
            catch (Exception e) {
                log.warn("Failed to create ConstraintValidator from OSGi Bundle. Falling back to default", (Throwable)e);
            }
        }
        return (T)super.getInstance(key);
    }

    private ContainerAccessor createContainerAccessor(Bundle bundle) {
        BundleContext context = bundle.getBundleContext();
        ServiceReference reference = (ServiceReference)Preconditions.checkNotNull((Object)context.getServiceReference(ApplicationContext.class.getName()), (Object)"ApplicationContext service references was not found");
        return new DefaultSpringContainerAccessor(context.getService(reference));
    }
}

