/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.i18n;

import com.atlassian.stash.i18n.I18nKey;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.i18n.KeyedMessage;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import org.springframework.context.MessageSource;

public class MessageSourceI18nService
implements I18nService {
    private static final Object[] NO_ARGS = new Object[0];
    private final MessageSource messageSource;
    private final Locale defaultLocale;

    public MessageSourceI18nService(@Nonnull MessageSource messageSource, @Nonnull Locale defaultLocale) {
        this.messageSource = messageSource;
        this.defaultLocale = defaultLocale;
    }

    @Nonnull
    public KeyedMessage createKeyedMessage(@Nonnull String key, Object ... arguments) {
        return this.getKeyedText(key, key, arguments);
    }

    @Nonnull
    public Map<String, String> getAllTranslationsForPrefix(@Nonnull String prefix) {
        return Collections.emptyMap();
    }

    @Nonnull
    public Map<String, String> getAllTranslationsForPrefix(@Nonnull String prefix, @Nonnull Locale locale) {
        return Collections.emptyMap();
    }

    @Nonnull
    public KeyedMessage getKeyedText(@Nonnull I18nKey i18nKey) {
        return this.getKeyedText(i18nKey.getKey(), null, i18nKey.getArguments());
    }

    @Nonnull
    public KeyedMessage getKeyedText(@Nonnull String key, String fallbackMessage, Object ... arguments) {
        String message = this.getText(key, this.fallbackElseKey(key, fallbackMessage), arguments);
        return new KeyedMessage(key, message, message);
    }

    @Nonnull
    public String getMessage(@Nonnull String key, Object ... arguments) {
        return this.getText(key, key, arguments);
    }

    @Nonnull
    public String getMessage(@Nonnull I18nKey i18nKey) {
        return this.getText(i18nKey.getKey(), i18nKey.getKey(), i18nKey.getArguments());
    }

    @Nonnull
    public String getMessagePattern(@Nonnull String key) {
        return this.getMessagePattern(key, key);
    }

    @Nonnull
    public String getMessagePattern(@Nonnull Locale locale, @Nonnull String key) {
        return this.messageSource.getMessage(key, NO_ARGS, key, locale);
    }

    @Nonnull
    public String getMessagePattern(@Nonnull String key, String fallbackMessage) {
        return this.messageSource.getMessage(key, NO_ARGS, this.fallbackElseKey(key, fallbackMessage), this.defaultLocale);
    }

    @Nonnull
    public String getText(@Nonnull Locale locale, @Nonnull String key, String fallbackMessage, Object ... arguments) {
        return this.messageSource.getMessage(key, arguments, this.fallbackElseKey(key, fallbackMessage), locale);
    }

    @Nonnull
    public String getText(@Nonnull String key, String fallbackMessage, Object ... arguments) {
        return this.messageSource.getMessage(key, arguments, this.fallbackElseKey(key, fallbackMessage), this.defaultLocale);
    }

    private String fallbackElseKey(String key, String fallbackMessage) {
        return fallbackMessage == null ? key : fallbackMessage;
    }
}

