/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.concurrent;

import com.atlassian.stash.util.PropertiesUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="executorServiceConfiguration")
public class ExecutorServiceConfiguration {
    private static int DEFAULT_CORE_THREADS_BASE = 100;
    private static int DEFAULT_CORE_THREADS_SCALE_FACTOR = 20;
    private final int corePoolSize;

    @Autowired
    public ExecutorServiceConfiguration(@Value(value="${executor.max.threads}") String coreThreads) {
        this.corePoolSize = PropertiesUtils.parseExpression((String)coreThreads, (int)(DEFAULT_CORE_THREADS_BASE + DEFAULT_CORE_THREADS_SCALE_FACTOR * Runtime.getRuntime().availableProcessors()));
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }
}

