/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.process;

import com.atlassian.stash.internal.ApplicationSettings;
import com.atlassian.stash.internal.process.ExternalProcessConfigurer;
import com.atlassian.utils.process.DefaultExternalProcessFactory;
import com.atlassian.utils.process.ExternalProcess;
import com.atlassian.utils.process.ExternalProcessBuilder;
import com.atlassian.utils.process.ExternalProcessFactory;
import com.atlassian.utils.process.ExternalProcessImpl;
import com.atlassian.utils.process.ExternalProcessSettings;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang.SystemUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class ConfigurableExternalProcessFactory
extends DefaultExternalProcessFactory {
    private final ApplicationSettings settings;
    private List<ExternalProcessConfigurer> configurers;
    private long executionTimeout;
    private long idleTimeout;

    public ConfigurableExternalProcessFactory(ExecutorService executorService, ApplicationSettings settings) {
        super(executorService);
        this.settings = settings;
        this.configurers = Collections.emptyList();
    }

    public ExternalProcess create(ExternalProcessSettings settings) {
        if (settings.getWorkingDirectory() == null) {
            settings.setWorkingDirectory(this.settings.getTempDir());
        }
        if (!settings.hasExecutionTimeout()) {
            settings.setExecutionTimeout(this.executionTimeout);
        }
        if (!settings.hasIdleTimeout()) {
            settings.setIdleTimeout(this.idleTimeout);
        }
        return super.create(settings);
    }

    @PostConstruct
    public void initialise() {
        ExternalProcessBuilder.setExternalProcessFactory((ExternalProcessFactory)this);
        if (SystemUtils.IS_OS_WINDOWS) {
            System.setProperty("winp.folder.preferred", new File(this.settings.getNativeDir(), "truncated").getAbsolutePath());
        }
    }

    @Autowired(required=false)
    public void setConfigurers(List<ExternalProcessConfigurer> configurers) {
        this.configurers = ImmutableList.copyOf(configurers);
    }

    @Value(value="${process.timeout.execution}")
    public void setExecutionTimeout(long executionTimeout) {
        this.executionTimeout = TimeUnit.SECONDS.toMillis(executionTimeout);
    }

    @Value(value="${process.timeout.idle}")
    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = TimeUnit.SECONDS.toMillis(idleTimeout);
    }

    @PreDestroy
    public void shutdown() {
        super.shutdown();
    }

    protected void configureProcess(ExternalProcessImpl process, ExternalProcessSettings settings) {
        for (ExternalProcessConfigurer configurer : this.configurers) {
            configurer.configure(process, settings);
        }
        String tempDir = this.settings.getTempDir().getAbsolutePath();
        Map environment = settings.getEnvironment();
        ConfigurableExternalProcessFactory.putIfAbsent(environment, "TMPDIR", tempDir);
        if (SystemUtils.IS_OS_WINDOWS) {
            ConfigurableExternalProcessFactory.putIfAbsent(environment, "TEMP", tempDir);
            ConfigurableExternalProcessFactory.putIfAbsent(environment, "TMP", tempDir);
        }
        super.configureProcess(process, settings);
    }

    private static void putIfAbsent(Map<String, String> map, String key, String value) {
        if (!map.containsKey(key)) {
            map.put(key, value);
        }
    }
}

