/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin.web.fragments;

import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.transformer.CharSequenceDownloadableResource;
import com.atlassian.plugin.webresource.transformer.WebResourceTransformer;
import com.atlassian.stash.internal.plugin.web.fragments.ClientWebFragmentFieldType;
import com.atlassian.stash.internal.plugin.web.fragments.ClientWebFragmentType;
import java.util.List;
import org.dom4j.Element;

public abstract class AbstractClientWebFragmentTransformer
implements WebResourceTransformer {
    protected abstract ClientWebFragmentType getFragmentType();

    public DownloadableResource transform(final Element configElement, ResourceLocation location, String filePath, DownloadableResource nextResource) {
        return new CharSequenceDownloadableResource(nextResource){

            protected CharSequence transform(CharSequence original) {
                return AbstractClientWebFragmentTransformer.this.parseConfig(configElement);
            }
        };
    }

    private ClientWebFragmentFieldType getType(Element element) {
        return ClientWebFragmentFieldType.fromTypeAttribute(element.attributeValue("type"));
    }

    private String getJsSrc(Element element, ClientWebFragmentFieldType type) {
        return type.toJsSrc(element);
    }

    private List<Element> getChildren(Element el) {
        return el.elements();
    }

    private StringBuilder appendElementAsJs(StringBuilder sb, Element root) {
        return this.appendElementAsJs(sb, root, this.getType(root));
    }

    private StringBuilder appendElementAsJs(StringBuilder sb, Element element, ClientWebFragmentFieldType type) {
        switch (type) {
            case OBJECT: {
                return this.appendElementAsJsObject(sb, element);
            }
            case ARRAY: {
                return this.appendElementAsJsArray(sb, element);
            }
        }
        return sb.append(this.getJsSrc(element, type));
    }

    private StringBuilder appendElementAsJsObject(StringBuilder sb, Element el) {
        sb.append('{');
        boolean firstProperty = true;
        for (Element element : this.getChildren(el)) {
            if (firstProperty) {
                firstProperty = false;
            } else {
                sb.append(",");
            }
            sb.append("'").append(element.getName()).append("':");
            this.appendElementAsJs(sb, element);
        }
        sb.append('}');
        return sb;
    }

    private StringBuilder appendElementAsJsArray(StringBuilder sb, Element element) {
        sb.append("[");
        boolean firstItem = true;
        for (Element childElement : this.getChildren(element)) {
            if (firstItem) {
                firstItem = false;
            } else {
                sb.append(",");
            }
            this.appendElementAsJs(sb, childElement);
        }
        return sb.append("]");
    }

    private CharSequence parseConfig(Element configElement) {
        StringBuilder sb = new StringBuilder(this.getFragmentType().getAddDescriptorJsMethod()).append("(");
        this.appendElementAsJsObject(sb, configElement);
        return sb.append(");").toString();
    }
}

