/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceBatchingStateCounter;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.cdn.CDNStrategy;
import com.atlassian.stash.event.request.RequestEndedEvent;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.ApplicationSettings;
import com.atlassian.stash.internal.BuildInfo;
import com.atlassian.stash.internal.locale.InternalLocaleService;
import com.atlassian.stash.nav.NavBuilder;
import com.google.common.base.Objects;
import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=WebResourceIntegration.class)
@Component(value="webResourceIntegration")
public class WebResourceIntegrationImpl
implements WebResourceIntegration {
    private static final String TMP_DIR_WEB_RESOURCES = "webresources";
    private final BuildInfo buildInfo;
    private final InternalLocaleService localeService;
    private final NavBuilder navBuilder;
    private final PluginAccessor pluginAccessor;
    private final ThreadLocal<Map<String, Object>> requestCache = new ThreadLocal<Map<String, Object>>(){

        @Override
        protected Map<String, Object> initialValue() {
            return new HashMap<String, Object>();
        }
    };
    private final ApplicationSettings settings;
    private final WebResourceBatchingStateCounter stateCounter;
    private final I18nService i18nService;

    @Autowired
    public WebResourceIntegrationImpl(BuildInfo buildInfo, InternalLocaleService localeService, NavBuilder navBuilder, PluginAccessor pluginAccessor, ApplicationSettings settings, WebResourceBatchingStateCounter stateCounter, I18nService i18nService) {
        this.buildInfo = buildInfo;
        this.localeService = localeService;
        this.navBuilder = navBuilder;
        this.pluginAccessor = pluginAccessor;
        this.settings = settings;
        this.stateCounter = stateCounter;
        this.i18nService = i18nService;
    }

    public String getBaseUrl() {
        return this.getBaseUrl(UrlMode.AUTO);
    }

    public String getBaseUrl(UrlMode urlMode) {
        return urlMode == UrlMode.ABSOLUTE ? this.navBuilder.buildAbsolute() : this.navBuilder.buildRelative();
    }

    public PluginAccessor getPluginAccessor() {
        return this.pluginAccessor;
    }

    public Map<String, Object> getRequestCache() {
        return this.requestCache.get();
    }

    public String getSystemBuildNumber() {
        return this.buildInfo.getDisplayCommitHash();
    }

    public String getSystemCounter() {
        return Long.toString(this.stateCounter.getBatchingStateCounter());
    }

    public String getSuperBatchVersion() {
        return Long.toString(this.stateCounter.getBatchingStateCounter());
    }

    public String getStaticResourceLocale() {
        return this.localeService.getLocale().toString();
    }

    public File getTemporaryDirectory() {
        return new File(this.settings.getTempDir(), TMP_DIR_WEB_RESOURCES);
    }

    public CDNStrategy getCDNStrategy() {
        return null;
    }

    public Locale getLocale() {
        return this.localeService.getLocale();
    }

    public String getI18nRawText(Locale locale, String key) {
        return (String)Objects.firstNonNull((Object)this.i18nService.getMessagePattern(locale, key), (Object)key);
    }

    public String getI18nText(Locale locale, String key) {
        return this.i18nService.getText(locale, key, null, new Object[0]);
    }

    @EventListener
    public void onRequestEnded(RequestEndedEvent event) {
        this.requestCache.remove();
    }
}

