/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.plugin.Application;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.main.PluginsConfiguration;
import com.atlassian.plugin.main.PluginsConfigurationBuilder;
import com.atlassian.plugin.manager.PluginPersistentStateStore;
import com.atlassian.plugin.osgi.container.PackageScannerConfiguration;
import com.atlassian.plugin.osgi.hostcomponents.HostComponentProvider;
import com.atlassian.stash.internal.ApplicationSettings;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.core.io.ClassPathResource;

public class PluginConfigurationFactoryBean
extends AbstractFactoryBean<PluginsConfiguration> {
    public static final String KEY_STASH_PLUGINS_LIST = "stash.plugins.list";
    private static final Logger LOG = LoggerFactory.getLogger(PluginConfigurationFactoryBean.class);
    private final ApplicationSettings applicationSettings;
    private final String bundledPlugins;
    private final Application hostApplication;
    private final HostComponentProvider hostComponentProvider;
    private final ModuleDescriptorFactory moduleDescriptorFactory;
    private final PackageScannerConfiguration packageScannerConfiguration;
    private final PluginPersistentStateStore pluginPersistentStateStore;

    public PluginConfigurationFactoryBean(ApplicationSettings applicationSettings, Application hostApplication, HostComponentProvider hostComponentProvider, ModuleDescriptorFactory moduleDescriptorFactory, PackageScannerConfiguration packageScannerConfiguration, PluginPersistentStateStore pluginPersistentStateStore, String bundledPlugins) {
        this.applicationSettings = applicationSettings;
        this.bundledPlugins = bundledPlugins.startsWith("/") ? bundledPlugins : "/" + bundledPlugins;
        this.hostApplication = hostApplication;
        this.hostComponentProvider = hostComponentProvider;
        this.moduleDescriptorFactory = moduleDescriptorFactory;
        this.packageScannerConfiguration = packageScannerConfiguration;
        this.pluginPersistentStateStore = pluginPersistentStateStore;
    }

    public Class<?> getObjectType() {
        return PluginsConfiguration.class;
    }

    protected PluginsConfiguration createInstance() throws Exception {
        URL bundledPluginsUrl = PluginConfigurationFactoryBean.getBundledPluginsUrl(this.bundledPlugins);
        return new PluginsConfigurationBuilder().useLegacyDynamicPluginDeployer(true).bundledPluginUrl(bundledPluginsUrl).bundledPluginCacheDirectory(this.applicationSettings.getBundledPluginsDir()).pluginDirectory(this.applicationSettings.getInstalledPluginsDir()).moduleDescriptorFactory(this.moduleDescriptorFactory).packageScannerConfiguration(this.packageScannerConfiguration).hostComponentProvider(this.hostComponentProvider).osgiPersistentCache(this.applicationSettings.getOsgiCacheDir()).pluginStateStore(this.pluginPersistentStateStore).application(this.hostApplication).build();
    }

    private static URL getBundledPluginsUrl(String bundledPlugins) throws IOException {
        String list = System.getProperty(KEY_STASH_PLUGINS_LIST);
        if (StringUtils.isNotBlank((String)list)) {
            try {
                return URI.create(list).toURL();
            }
            catch (MalformedURLException e) {
                LOG.warn("stash.plugins.list does not define a valid URL [" + list + "]", (Throwable)e);
            }
        }
        return new ClassPathResource(bundledPlugins).getURL();
    }
}

