/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal;

import com.atlassian.stash.Product;
import com.atlassian.stash.repository.Version;
import com.atlassian.stash.util.FileUtils;
import com.atlassian.stash.util.PropertiesUtils;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationSettings {
    private static final Logger log = LoggerFactory.getLogger(ApplicationSettings.class);
    public static final String LOG_PATH = "log";
    static final String VERSION_FILE_NAME = ".version";
    static final String STASH_HOME_BUILD_VERSION_PROPERTY = "stash.home.build.version";
    private final File backupDir;
    private final File binDir;
    private final File bundledPluginsDir;
    private final File cacheDir;
    private final File configDir;
    private final File dataDir;
    private final File homeDir;
    private final File installedPluginsDir;
    private final File libDir;
    private final File logDir;
    private final File nativeDir;
    private final File pluginsDir;
    private final File osgiCacheDir;
    private final Set<String> requiredPluginKeys;
    private final File reposDir;
    private final File tempDir;

    public ApplicationSettings(File homeDir, Properties requiredPluginProperties, Properties versionProperties, String currentBuildVersion) {
        this.homeDir = homeDir;
        if (!homeDir.exists()) {
            throw new IllegalStateException("Home directory [" + homeDir + "] does not exist");
        }
        if (!homeDir.isDirectory()) {
            throw new IllegalStateException("Home directory [" + homeDir + "] is not a directory");
        }
        if (SystemUtils.IS_OS_WINDOWS && homeDir.getPath().length() > 200) {
            log.warn("{} Home Directory is close to the Window's max file path length ({}). This may prevent merging pull requests in the {} Web UI. See {} for more details.", new Object[]{Product.NAME, homeDir.getPath().length(), Product.NAME, "https://confluence.atlassian.com/x/04oMEg"});
        }
        log.debug("Running with Home Directory = {}", (Object)homeDir);
        this.backupDir = ApplicationSettings.getHomeSubdirectory(homeDir, "export");
        this.binDir = ApplicationSettings.getHomeSubdirectory(homeDir, "bin");
        this.cacheDir = ApplicationSettings.getHomeSubdirectory(homeDir, "caches");
        this.configDir = ApplicationSettings.getHomeSubdirectory(homeDir, "config");
        this.dataDir = ApplicationSettings.getHomeSubdirectory(homeDir, "data");
        this.libDir = ApplicationSettings.getHomeSubdirectory(homeDir, "lib");
        this.logDir = ApplicationSettings.getHomeSubdirectory(homeDir, LOG_PATH);
        this.nativeDir = ApplicationSettings.getHomeSubdirectory(this.libDir, "native");
        this.reposDir = FileUtils.mkdir((File)this.dataDir, (String)"repositories");
        this.tempDir = ApplicationSettings.getHomeSubdirectory(homeDir, "tmp");
        this.pluginsDir = ApplicationSettings.getHomeSubdirectory(homeDir, "plugins");
        this.installedPluginsDir = FileUtils.mkdir((File)this.pluginsDir, (String)"installed-plugins");
        this.osgiCacheDir = FileUtils.mkdir((File)this.pluginsDir, (String)".osgi-cache");
        this.bundledPluginsDir = FileUtils.mkdir((File)this.pluginsDir, (String)".bundled-plugins");
        ImmutableSet.Builder requiredPluginsBuilder = ImmutableSet.builder();
        if (requiredPluginProperties != null) {
            requiredPluginsBuilder.addAll((Iterable)Collections2.transform(requiredPluginProperties.keySet(), (Function)Functions.toStringFunction()));
        }
        this.requiredPluginKeys = requiredPluginsBuilder.build();
        this.updateHomeDirectoryVersions(versionProperties, new Version(currentBuildVersion));
    }

    public File getBackupDir() {
        return this.backupDir;
    }

    public File getBinDir() {
        return this.binDir;
    }

    public File getBundledPluginsDir() {
        return this.bundledPluginsDir;
    }

    public File getCacheDir() {
        return this.cacheDir;
    }

    public File getConfigDir() {
        return this.configDir;
    }

    public File getDataDir() {
        return this.dataDir;
    }

    public File getHomeDir() {
        return this.homeDir;
    }

    public File getInstalledPluginsDir() {
        return this.installedPluginsDir;
    }

    public File getLibDir() {
        return this.libDir;
    }

    public File getLogDir() {
        return this.logDir;
    }

    public File getNativeDir() {
        return this.nativeDir;
    }

    public File getOsgiCacheDir() {
        return this.osgiCacheDir;
    }

    public File getPluginsDir() {
        return this.pluginsDir;
    }

    public File getRepositoriesDir() {
        return this.reposDir;
    }

    public File getTempDir() {
        return this.tempDir;
    }

    public Set<String> getRequiredPluginKeys() {
        return this.requiredPluginKeys;
    }

    private static File getHomeSubdirectory(File parent, String name) {
        String key = "stash.home." + name;
        String override = System.getProperty(key, System.getenv(key.replace(".", "_").toUpperCase()));
        return override == null ? FileUtils.mkdir((File)parent, (String)name) : FileUtils.mkdir((String)override);
    }

    private void updateHomeDirectoryVersions(Properties versionProperties, Version sourceBuild) {
        Version homeBuild = null;
        if (versionProperties != null) {
            String homeBuildString = versionProperties.getProperty(STASH_HOME_BUILD_VERSION_PROPERTY);
            if (StringUtils.isNotEmpty((String)homeBuildString)) {
                homeBuild = new Version(homeBuildString);
                if (homeBuild.compareTo(sourceBuild) > 0) {
                    log.warn("The configured home directory {} is at a higher build version {} than the Stash code build version {}", new Object[]{this.getHomeDir(), homeBuild, sourceBuild});
                    return;
                }
                if (homeBuild.compareTo(sourceBuild) < 0) {
                    log.info("Updated home version from {} to {}", (Object)homeBuild, (Object)sourceBuild);
                    this.writeHomeDirectoryVersion(versionProperties, sourceBuild);
                }
            }
        } else {
            versionProperties = new Properties();
        }
        if (homeBuild == null) {
            log.info("Capturing benchmark home version {}", (Object)sourceBuild);
            this.writeHomeDirectoryVersion(versionProperties, sourceBuild);
        }
    }

    private void writeHomeDirectoryVersion(Properties versionProperties, Version sourceBuild) {
        File versionFile = new File(this.getHomeDir(), VERSION_FILE_NAME);
        versionProperties.setProperty(STASH_HOME_BUILD_VERSION_PROPERTY, sourceBuild.toString());
        try {
            PropertiesUtils.writeToFile((Properties)versionProperties, (File)versionFile);
        }
        catch (IOException e) {
            log.warn("Failed to write home directory version", (Throwable)e);
        }
    }
}

