/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin.web.fragments;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.hostcontainer.HostContainer;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.web.WebFragmentHelper;
import com.atlassian.plugin.web.descriptors.ConditionElementParser;
import com.atlassian.stash.internal.plugin.WebResourceGenerationHelper;
import com.atlassian.stash.internal.plugin.web.fragments.AbstractClientWebFragmentModuleDescriptor;
import com.atlassian.stash.internal.plugin.web.fragments.ClientWebFragmentFieldType;
import com.atlassian.stash.internal.plugin.web.fragments.ClientWebFragmentType;
import com.atlassian.stash.internal.plugin.web.fragments.ClientWebInterfaceManager;
import org.dom4j.Element;

public class ConfigurationFormModuleDescriptor
extends AbstractClientWebFragmentModuleDescriptor {
    public static final String XML_ELEMENT_NAME = "config-form";
    public static final String CONFIGURATION_FORM_DEPENDENCY = "com.atlassian.stash.stash-web-plugin:configuration-form";
    private final WebResourceGenerationHelper webResourceGenerationHelper;
    private String implicitContext;

    public ConfigurationFormModuleDescriptor(ModuleFactory moduleFactory, HostContainer hostContainer, ClientWebInterfaceManager clientWebInterfaceManager, ConditionElementParser.ConditionFactory conditionFactory, WebFragmentHelper webFragmentHelper, WebResourceGenerationHelper webResourceGenerationHelper) {
        super(moduleFactory, hostContainer, clientWebInterfaceManager, conditionFactory, webFragmentHelper);
        this.webResourceGenerationHelper = webResourceGenerationHelper;
    }

    @Override
    protected void addDefaultFields(Element container, Element originalElement) {
        String moduleKey = originalElement.attributeValue("key");
        this.addStringElement(container, "pluginKey", this.plugin.getKey());
        this.addStringElement(container, "key", moduleKey);
        this.addStringElement(container, "moduleKey", moduleKey);
        this.addStringElement(container, "completeModuleKey", this.plugin.getKey() + ":" + moduleKey);
        this.addStringElement(container, "name", originalElement.attributeValue("name"));
        this.copyElement("client-context-provider", originalElement, container, ClientWebFragmentFieldType.JS);
        this.copyParamElements(originalElement, container);
    }

    @Override
    public void init(Plugin plugin, Element element) throws PluginParseException {
        this.implicitContext = plugin.getKey() + ":" + element.attribute("key").getValue();
        element.addElement("context").setText(this.implicitContext);
        element.addElement("dependency").setText(CONFIGURATION_FORM_DEPENDENCY);
        super.init(plugin, element);
    }

    @Override
    protected Element generateElement(Element originalElement) {
        Element generated = super.generateElement(originalElement);
        this.webResourceGenerationHelper.addDefaultTransforms(generated);
        return generated;
    }

    @Override
    protected boolean postEnableProcessing() {
        this.webResourceGenerationHelper.addResourceElements(this);
        return true;
    }

    @Override
    protected void addFields(Element container, Element originalElement) {
        this.addStringElement(container, "location", this.implicitContext);
        this.copyElement("view", originalElement, container, ClientWebFragmentFieldType.JS);
    }

    @Override
    protected ClientWebFragmentType getFragmentType() {
        return ClientWebFragmentType.PANEL;
    }

    @Override
    public String getLocation() {
        return this.implicitContext;
    }
}

