/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.logback.pattern;

import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.PublicThrowableProxyUtil;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import com.atlassian.stash.util.TextUtils;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;

public class FilteredThrowableProxy
implements IThrowableProxy {
    private static final Set<String> IGNORABLE_PREFIXES = ImmutableSet.builder().add((Object)"$Proxy").add((Object)"com.atlassian.johnson.").add((Object)"com.atlassian.plugin.osgi.").add((Object)"com.atlassian.plugin.servlet.").add((Object)"com.atlassian.plugins.rest.").add((Object)"com.atlassian.prettyurls.").add((Object)"com.atlassian.stash.internal.aop.").add((Object)"com.atlassian.stash.internal.johnson.").add((Object)"com.atlassian.stash.internal.web.filters.").add((Object)"com.opensymphony.module.sitemesh.").add((Object)"com.sun.jersey.").add((Object)"com.sun.jmx.").add((Object)"java.lang.ClassLoader").add((Object)"java.lang.reflect.").add((Object)"java.util.concurrent.ThreadPoolExecutor$Worker").add((Object)"javax.management.remote.rmi.").add((Object)"javax.servlet.http.HttpServlet").add((Object)"org.apache.catalina.").add((Object)"org.apache.coyote.").add((Object)"org.apache.felix.").add((Object)"org.apache.tomcat.").add((Object)"org.springframework.aop.").add((Object)"org.springframework.beans.factory.").add((Object)"org.springframework.osgi.").add((Object)"org.springframework.security.").add((Object)"org.springframework.transaction.interceptor.").add((Object)"org.springframework.web.filter.").add((Object)"org.springframework.web.method.support.InvocableHandlerMethod").add((Object)"org.springframework.web.servlet.").add((Object)"org.tuckey.").add((Object)"sun.reflect.").add((Object)"sun.rmi.").build();
    private final IThrowableProxy throwable;
    private final FilteredThrowableProxy cause;
    private final FilteredThrowableProxy[] suppressed;
    private final StackTraceElementProxy[] stackTrace;
    private int commonFrames;

    public FilteredThrowableProxy(IThrowableProxy throwable) {
        this.throwable = throwable;
        this.stackTrace = FilteredThrowableProxy.filterElements(throwable.getStackTraceElementProxyArray());
        IThrowableProxy cause = throwable.getCause();
        if (cause == null) {
            this.cause = null;
        } else {
            this.cause = new FilteredThrowableProxy(cause);
            this.cause.commonFrames = FilteredThrowableProxy.findNumberOfCommonFrames(this.cause, this);
        }
        IThrowableProxy[] suppressed = throwable.getSuppressed();
        FilteredThrowableProxy[] proxies = new FilteredThrowableProxy[suppressed.length];
        for (int i = 0; i < suppressed.length; ++i) {
            proxies[i] = new FilteredThrowableProxy(suppressed[i]);
            proxies[i].commonFrames = FilteredThrowableProxy.findNumberOfCommonFrames(proxies[i], this);
        }
        this.suppressed = proxies;
    }

    public String getClassName() {
        return this.throwable.getClassName();
    }

    public IThrowableProxy getCause() {
        return this.cause;
    }

    public int getCommonFrames() {
        return this.commonFrames;
    }

    public String getMessage() {
        return this.throwable.getMessage();
    }

    public StackTraceElementProxy[] getStackTraceElementProxyArray() {
        return this.stackTrace;
    }

    public IThrowableProxy[] getSuppressed() {
        return this.suppressed;
    }

    IThrowableProxy getThrowableProxy() {
        return this.throwable;
    }

    private static int findNumberOfCommonFrames(FilteredThrowableProxy cause, FilteredThrowableProxy exception) {
        StackTraceElementProxy[] causeProxyStack = cause.getStackTraceElementProxyArray();
        StackTraceElement[] causeStack = Lists.transform(Arrays.asList(causeProxyStack), (Function)new Function<StackTraceElementProxy, StackTraceElement>(){

            public StackTraceElement apply(StackTraceElementProxy proxy) {
                return proxy.getStackTraceElement();
            }
        }).toArray(new StackTraceElement[causeProxyStack.length]);
        return PublicThrowableProxyUtil.findNumberOfCommonFrames(causeStack, exception.getStackTraceElementProxyArray());
    }

    private static StackTraceElementProxy[] filterElements(StackTraceElementProxy[] stackTrace) {
        int trimmed;
        ArrayList<StackTraceElementProxy> filteredStackTrace = new ArrayList<StackTraceElementProxy>(FilteredThrowableProxy.estimateStackSize(stackTrace));
        if (stackTrace.length > 0) {
            filteredStackTrace.add(stackTrace[0]);
            for (int i = 1; i < stackTrace.length; ++i) {
                StackTraceElementProxy element = stackTrace[i];
                String clazz = element.getStackTraceElement().getClassName();
                boolean match = false;
                for (String prefix : IGNORABLE_PREFIXES) {
                    if (match |= clazz.startsWith(prefix)) break;
                }
                if (match) continue;
                filteredStackTrace.add(element);
            }
        }
        if ((trimmed = stackTrace.length - filteredStackTrace.size()) > 0) {
            filteredStackTrace.add(new Placeholder("... " + trimmed + ' ' + TextUtils.pluralise((String)"frame", (String)"frames", (long)trimmed) + " trimmed"));
        }
        return filteredStackTrace.toArray(new StackTraceElementProxy[filteredStackTrace.size()]);
    }

    private static int estimateStackSize(StackTraceElementProxy[] stackTrace) {
        return stackTrace.length / 10;
    }

    static class Placeholder
    extends StackTraceElementProxy {
        private final String placeholder;

        Placeholder(String placeholder) {
            super(new StackTraceElement("Unknown frame", "unknown", "Unknown frame", -1));
            this.placeholder = placeholder;
        }

        public String toString() {
            return this.placeholder;
        }
    }
}

