/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin.web.fragments;

import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.Resources;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.hostcontainer.HostContainer;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.web.WebFragmentHelper;
import com.atlassian.stash.internal.plugin.web.fragments.AbstractClientWebFragmentModuleDescriptor;
import com.atlassian.stash.internal.plugin.web.fragments.ClientWebFragmentFieldType;
import com.atlassian.stash.internal.plugin.web.fragments.ClientWebFragmentType;
import com.atlassian.stash.internal.plugin.web.fragments.ClientWebInterfaceManager;
import java.util.List;
import org.dom4j.Element;

public class ClientWebPanelModuleDescriptor
extends AbstractClientWebFragmentModuleDescriptor {
    public static final String XML_ELEMENT_NAME = "client-web-panel".intern();
    private String location;
    private Element fieldContainer;

    public ClientWebPanelModuleDescriptor(ModuleFactory moduleFactory, HostContainer hostContainer, ClientWebInterfaceManager clientWebInterfaceManager, WebFragmentHelper webFragmentHelper) {
        super(moduleFactory, hostContainer, clientWebInterfaceManager, webFragmentHelper);
    }

    @Override
    protected ClientWebFragmentType getFragmentType() {
        return ClientWebFragmentType.PANEL;
    }

    @Override
    protected Element generateElement(Element originalElement) {
        Element generatedElement = super.generateElement(originalElement);
        this.resources = Resources.fromXml((Element)generatedElement);
        this.addView(this.fieldContainer, generatedElement, this.getOriginalElement());
        return generatedElement;
    }

    @Override
    protected void addFields(Element container, Element originalElement) {
        this.location = originalElement.attributeValue("location");
        if (this.location == null) {
            throw new PluginParseException("location is a required attribute for client web panels.");
        }
        this.fieldContainer = container;
        this.addStringElement(container, "location", this.location);
    }

    private void addView(Element fieldContainer, Element generatedElement, Element originalElement) {
        List viewElements = originalElement.elements("view");
        ResourceDescriptor soyViewResource = this.getResourceDescriptor("soy", "view");
        ResourceDescriptor staticViewResource = this.getResourceDescriptor("static", "view");
        int viewCount = viewElements.size() + (soyViewResource != null ? 1 : 0) + (staticViewResource != null ? 1 : 0);
        if (viewCount > 1) {
            throw new PluginParseException("Only one view may be specified.");
        }
        this.copyElement("view", originalElement, fieldContainer, ClientWebFragmentFieldType.JS);
        if (soyViewResource != null) {
            String[] locationParts = soyViewResource.getLocation().split("/");
            if (locationParts.length != 2) {
                throw new PluginParseException("Template name must have two parts - completeModuleKey/templateName");
            }
            String soyDependencyKey = locationParts[0];
            String templateName = locationParts[1];
            this.addSoyTransformer(generatedElement);
            this.getOrAddChild(generatedElement, "dependency", soyDependencyKey);
            this.addElement(fieldContainer, "view", ClientWebFragmentFieldType.JS, templateName);
        }
        if (staticViewResource != null) {
            this.addElement(fieldContainer, "view", ClientWebFragmentFieldType.TEXT, staticViewResource.getContent());
        }
    }

    private void addSoyTransformer(Element container) {
        Element soyTransformation = this.getOrAddChild(container, "transformation", "extension", "soy");
        this.getOrAddChild(soyTransformation, "transformer", "key", "soyTransformer");
    }

    private Element getOrAddChild(Element container, String tagName, String attributeName, String attributeValue) {
        for (Object o : container.elements(tagName)) {
            Element e = (Element)o;
            if (!attributeValue.equals(e.attributeValue(attributeName))) continue;
            return e;
        }
        Element element = container.addElement(tagName);
        element.addAttribute(attributeName, attributeValue);
        return element;
    }

    private Element getOrAddChild(Element container, String tagName, String text) {
        String trimmedText = text.trim();
        for (Object o : container.elements(tagName)) {
            Element e = (Element)o;
            if (!trimmedText.equals(e.getTextTrim())) continue;
            return e;
        }
        Element element = container.addElement(tagName);
        element.addText(trimmedText);
        return element;
    }

    @Override
    public String getLocation() {
        return this.location;
    }
}

