/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.sal.core.pluginsettings.AbstractStringPluginSettings;
import com.atlassian.stash.internal.plugin.PluginSettingDao;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="pluginSettingsPrototype")
@Scope(value="prototype")
@Transactional
public class StashPluginSettings
extends AbstractStringPluginSettings {
    private final PluginSettingDao keyValueStore;
    private final String pluginKey;

    public StashPluginSettings(PluginSettingDao keyValueStore, String pluginKey) {
        this.keyValueStore = keyValueStore;
        this.pluginKey = pluginKey;
    }

    public Object put(String key, Object value) {
        return super.put(key, value);
    }

    @Transactional(readOnly=true)
    public Object get(String key) {
        return super.get(key);
    }

    public Object remove(String key) {
        return super.remove(key);
    }

    protected void putActual(String key, String val) {
        this.keyValueStore.put(this.pluginKey, key, val);
    }

    protected String getActual(String key) {
        return this.keyValueStore.get(this.pluginKey, key);
    }

    protected void removeActual(String key) {
        this.keyValueStore.remove(this.pluginKey, key);
    }
}

