/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.util.validation.ValidationPattern;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.web.descriptors.ConditionElementParser;
import com.atlassian.stash.internal.plugin.StashConditionFactory;
import com.atlassian.stash.scm.BaseWeightedModuleDescriptor;
import com.atlassian.stash.ui.ContextualFormFragment;
import com.atlassian.stash.ui.FormFragment;
import com.atlassian.stash.ui.ValidationErrors;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dom4j.Element;

public class FormFragmentModuleDescriptor
extends BaseWeightedModuleDescriptor<ContextualFormFragment> {
    public static final String XML_ELEMENT_NAME = "form-fragment";
    private final ConditionElementParser conditionElementParser;
    private String location = null;
    private Element element = null;
    private Condition condition = null;

    public FormFragmentModuleDescriptor(ModuleFactory moduleFactory, StashConditionFactory stashConditionFactory) {
        super(moduleFactory, 100);
        this.conditionElementParser = new ConditionElementParser((ConditionElementParser.ConditionFactory)stashConditionFactory);
    }

    public void init(@Nonnull Plugin plugin, @Nonnull Element element) throws PluginParseException {
        super.init(plugin, element);
        this.location = element.attribute("location").getValue();
        this.element = element;
    }

    public void enabled() {
        super.enabled();
        this.condition = this.conditionElementParser.makeConditions(this.plugin, this.element, 1);
    }

    public void disabled() {
        this.condition = null;
        super.disabled();
    }

    protected void provideValidationRules(ValidationPattern pattern) {
        super.provideValidationRules(pattern);
        pattern.rule(new ValidationPattern.RuleTest[]{ValidationPattern.test((String)"@class").withError("The class is required")});
        pattern.rule(new ValidationPattern.RuleTest[]{ValidationPattern.test((String)"@location").withError("The location is required")});
    }

    public ContextualFormFragment getModule() {
        Object module = this.moduleFactory.createModule(this.moduleClassName, (ModuleDescriptor)this);
        if (module instanceof FormFragment) {
            return new ContextualFormFragmentAdaptor((FormFragment)module);
        }
        if (module instanceof ContextualFormFragment) {
            return (ContextualFormFragment)module;
        }
        throw new IllegalStateException("Module was expected to be a FormFragment or a ContextualFormFragment");
    }

    @Nullable
    public Condition getCondition() {
        return this.condition;
    }

    @Nonnull
    public String getLocation() {
        return this.location;
    }

    private static class ContextualFormFragmentAdaptor
    implements ContextualFormFragment {
        private final FormFragment formFragment;

        private ContextualFormFragmentAdaptor(FormFragment formFragment) {
            this.formFragment = formFragment;
        }

        public void doView(Appendable appendable, Map<String, Object> context) throws IOException {
            this.formFragment.doView(appendable);
        }

        public void validate(Map<String, String[]> requestParams, ValidationErrors errors, Map<String, Object> context) {
            this.formFragment.validate(requestParams, errors);
        }

        public void doError(Appendable appendable, Map<String, String[]> requestParams, Map<String, Collection<String>> fieldErrors, Map<String, Object> context) throws IOException {
            this.formFragment.doError(appendable, requestParams, fieldErrors);
        }

        public void execute(Map<String, String[]> requestParams, Map<String, Object> context) {
            this.formFragment.execute(requestParams);
        }
    }
}

