/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.help;

import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.help.HelpPathService;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=HelpPathService.class)
@Component(value="helpPathService")
public class HelpPathServiceImpl
implements HelpPathService {
    private final Properties helpProperties;

    @Autowired
    public HelpPathServiceImpl(@Qualifier(value="helpPathProperties") Properties properties) {
        this.helpProperties = properties;
    }

    public String getPageAlt(String topicKey) {
        return topicKey == null ? null : this.helpProperties.getProperty(topicKey + ".alt");
    }

    public String getPageKey(String topicKey) {
        return topicKey == null ? null : this.helpProperties.getProperty(topicKey);
    }

    public String getPageTitle(String topicKey) {
        return topicKey == null ? null : this.helpProperties.getProperty(topicKey + ".title");
    }

    public String getPageUrl(String topicKey) {
        String helpPrefix = this.getPrefix(topicKey);
        String helpPageKey = this.getPageKey(topicKey);
        if (helpPageKey != null && helpPrefix != null) {
            return String.format("%s/%s", helpPrefix, helpPageKey);
        }
        return null;
    }

    public String getPrefix() {
        return this.helpProperties.getProperty("stash.help.prefix");
    }

    private String getPrefix(String topicKey) {
        if (StringUtils.startsWith((String)topicKey, (String)"stash.kb.")) {
            return this.helpProperties.getProperty("stash.kb.prefix");
        }
        return this.getPrefix();
    }
}

