/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.event;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.event.StashEvent;
import com.atlassian.stash.event.annotation.TransactionAware;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.ReflectionUtils;

public class TransactionAwareEventPublisher
implements EventPublisher,
ApplicationListener<ContextRefreshedEvent> {
    private static final Logger log = LoggerFactory.getLogger(TransactionAwareEventPublisher.class);
    private final EventPublisher delegate;
    private final Field userField;
    private StashAuthenticationContext authenticationContext;

    @Autowired
    public TransactionAwareEventPublisher(EventPublisher delegate) {
        this.delegate = delegate;
        this.userField = TransactionAwareEventPublisher.getField("user");
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.authenticationContext = (StashAuthenticationContext)event.getApplicationContext().getBean(StashAuthenticationContext.class);
    }

    public void publish(@Nonnull Object event) {
        TransactionAware.When publishWhen;
        this.setFields(Preconditions.checkNotNull((Object)event, (Object)"event"));
        if (TransactionSynchronizationManager.isActualTransactionActive() && TransactionSynchronizationManager.isSynchronizationActive() && (publishWhen = TransactionAwareEventPublisher.getTransactionConfiguration(event.getClass())) != null && publishWhen != TransactionAware.When.IMMEDIATE) {
            log.debug("Deferring publishing for {} until {}", (Object)event.getClass().getSimpleName(), (Object)publishWhen);
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)this.createPublisher(publishWhen, event));
            return;
        }
        this.delegate.publish(event);
    }

    public void register(Object listener) {
        this.delegate.register(listener);
    }

    public void unregister(Object listener) {
        this.delegate.unregister(listener);
    }

    public void unregisterAll() {
        this.delegate.unregisterAll();
    }

    protected void setFields(Object event) {
        if (event instanceof StashEvent && this.authenticationContext != null) {
            ReflectionUtils.setField((Field)this.userField, (Object)event, (Object)this.authenticationContext.getCurrentUser());
        }
    }

    protected static Field getField(String fieldName) {
        Field field = ReflectionUtils.findField(StashEvent.class, (String)fieldName);
        ReflectionUtils.makeAccessible((Field)field);
        return field;
    }

    private TransactionSynchronization createPublisher(TransactionAware.When publishWhen, Object event) {
        switch (publishWhen) {
            case AFTER_COMMIT: {
                return new AfterCommitPublisher(event);
            }
            case AFTER_COMPLETION: {
                return new AfterCompletionPublisher(event);
            }
        }
        throw new IllegalArgumentException(publishWhen + " is not a known publishing point");
    }

    private static TransactionAware.When getTransactionConfiguration(Class eventClass) {
        TransactionAware annotation = (TransactionAware)AnnotationUtils.findAnnotation((Class)eventClass, TransactionAware.class);
        return annotation != null ? annotation.value() : null;
    }

    private class AfterCompletionPublisher
    extends TransactionSynchronizationAdapter {
        private final Object event;

        public AfterCompletionPublisher(Object event) {
            this.event = event;
        }

        public void afterCompletion(int status) {
            log.debug("Publishing {} after completion (Status: {})", (Object)this.event.getClass().getSimpleName(), (Object)status);
            TransactionAwareEventPublisher.this.delegate.publish(this.event);
        }
    }

    private class AfterCommitPublisher
    extends TransactionSynchronizationAdapter {
        private final Object event;

        public AfterCommitPublisher(Object event) {
            this.event = event;
        }

        public void afterCompletion(int status) {
            if (status == 0) {
                log.debug("Publishing {} after commit", (Object)this.event.getClass().getSimpleName());
                TransactionAwareEventPublisher.this.delegate.publish(this.event);
            } else {
                log.trace("Discarding {}; the transaction was not committed (Status: {})", (Object)this.event.getClass().getSimpleName(), (Object)status);
            }
        }
    }
}

