/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.aui.spi;

import com.atlassian.aui.spi.AuiIntegration;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.nav.NavBuilder;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AvailableToPlugins(value=AuiIntegration.class)
public class StashAuiIntegration
implements AuiIntegration {
    private final NavBuilder navBuilder;
    private final I18nService i18nService;

    @Autowired
    public StashAuiIntegration(NavBuilder navBuilder, I18nService i18nService) {
        this.navBuilder = navBuilder;
        this.i18nService = i18nService;
    }

    public String getContextPath() {
        return this.navBuilder.buildRelative();
    }

    public String getRawText(String key) {
        return this.i18nService.getMessagePattern(key, null);
    }

    public String getText(String key, Serializable ... args) {
        return this.i18nService.getText(key, null, (Object[])args);
    }
}

