/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.aop;

import com.atlassian.stash.util.Timer;
import com.atlassian.stash.util.TimerUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Order(value=5)
public class ProfilingAspect {
    @Pointcut(value="@within(org.springframework.stereotype.Repository)")
    public void daoMethod() {
    }

    @Pointcut(value="@within(org.springframework.stereotype.Service)")
    public void serviceMethod() {
    }

    @Pointcut(value="@within(com.atlassian.stash.internal.annotation.Profiled) || @annotation(com.atlassian.stash.internal.annotation.Profiled)")
    public void profiledMethod() {
    }

    @Pointcut(value="@annotation(com.atlassian.stash.internal.annotation.NotProfiled)")
    public void notProfiledMethod() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="(daoMethod() || serviceMethod() || profiledMethod()) && !notProfiledMethod()")
    public Object profileMethod(ProceedingJoinPoint joinPoint) throws Throwable {
        if (TimerUtils.isActive()) {
            Timer timer = TimerUtils.start((String)joinPoint.getSignature().toString());
            try {
                Object object = joinPoint.proceed();
                return object;
            }
            finally {
                timer.stop();
            }
        }
        return joinPoint.proceed();
    }
}

