/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.plugin.servlet.ServletContextFactory;
import com.atlassian.stash.internal.plugin.PluginPathScanner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;

public class StaticPluginPathScanner
implements PluginPathScanner {
    private final ServletContextFactory servletContextFactory;

    public StaticPluginPathScanner(ServletContextFactory servletContextFactory) {
        this.servletContextFactory = servletContextFactory;
    }

    @Override
    public Iterable<String> getPaths(String directoryToScan) {
        ArrayList<String> paths = new ArrayList<String>();
        this.recursePath(directoryToScan, paths);
        return paths;
    }

    private void recursePath(String directory, Collection<String> paths) {
        Set resourcePaths = this.servletContextFactory.getServletContext().getResourcePaths(directory);
        if (resourcePaths == null) {
            throw new NullPointerException("Directory does not exist: " + directory);
        }
        for (String resourcePath : resourcePaths) {
            if (resourcePath.endsWith("/")) {
                this.recursePath(resourcePath, paths);
                continue;
            }
            paths.add(resourcePath);
        }
    }
}

