/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.hostcontainer.HostContainer;
import com.atlassian.plugin.module.ContainerManagedPlugin;
import com.atlassian.plugin.util.ClassLoaderUtils;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.plugin.web.WebFragmentHelper;
import com.atlassian.plugin.web.conditions.ConditionLoadingException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.plugin.OsgiServiceProxyFactory;
import com.atlassian.stash.view.VelocityHelper;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StashWebFragmentHelper
implements WebFragmentHelper {
    private static final Object[] EMPTY_OBJECT = new Object[0];
    private final VelocityHelper velocityHelper;
    private final I18nService i18nService;
    private final HostContainer hostContainer;

    @Autowired
    public StashWebFragmentHelper(OsgiServiceProxyFactory osgiServiceProxyFactory, I18nService i18nService, HostContainer hostContainer) {
        this.hostContainer = hostContainer;
        this.velocityHelper = osgiServiceProxyFactory.createProxy(VelocityHelper.class, 1000L);
        this.i18nService = i18nService;
    }

    public Condition loadCondition(String className, Plugin plugin) throws ConditionLoadingException {
        this.assertClassNameNotBlank(className, plugin, "condition");
        return (Condition)this.loadComponent(className, plugin);
    }

    private void assertClassNameNotBlank(String className, Plugin plugin, String type) throws ConditionLoadingException {
        if (StringUtils.isBlank((String)className)) {
            throw new ConditionLoadingException("null or empty " + type + " class name in plugin " + plugin.getKey());
        }
    }

    public ContextProvider loadContextProvider(String className, Plugin plugin) throws ConditionLoadingException {
        this.assertClassNameNotBlank(className, plugin, "context provider");
        return (ContextProvider)this.loadComponent(className, plugin);
    }

    private <T> T loadComponent(String className, Plugin plugin) throws ConditionLoadingException {
        Class clazz;
        try {
            clazz = plugin.loadClass(className, StashWebFragmentHelper.class);
        }
        catch (ClassNotFoundException e) {
            try {
                clazz = ClassLoaderUtils.loadClass((String)className, StashWebFragmentHelper.class);
            }
            catch (ClassNotFoundException e1) {
                throw new ConditionLoadingException("Failed to load class '" + className + "' for plugin " + plugin.getName(), (Throwable)e);
            }
        }
        if (plugin instanceof ContainerManagedPlugin) {
            return (T)((ContainerManagedPlugin)plugin).getContainerAccessor().createBean(clazz);
        }
        return (T)this.hostContainer.create(clazz);
    }

    public String getI18nValue(String key, List<?> arguments, Map<String, Object> context) {
        return this.i18nService.getText(key, null, arguments == null ? EMPTY_OBJECT : arguments.toArray());
    }

    public String renderVelocityFragment(String fragment, Map<String, Object> params) {
        return this.velocityHelper.renderFragment(fragment, params);
    }
}

