/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.Resources;
import com.atlassian.plugin.hostcontainer.HostContainer;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import com.atlassian.stash.internal.plugin.PluginPathScanner;
import com.atlassian.stash.internal.plugin.PluginPathScannerFactory;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

public class StashResourceModuleDescriptor
extends WebResourceModuleDescriptor {
    public static final String XML_ELEMENT_NAME = "stash-resource".intern();
    private static final PathMatcher PATH_MATCHER = new AntPathMatcher();
    private static final Map<String, Collection<String>> RESOURCE_TRANSFORMS = ImmutableMap.builder().put((Object)"js", (Object)Lists.newArrayList((Object[])new String[]{"stashJsHelp", "stashJsI18n", "jsI18n"})).put((Object)"soy", (Object)Lists.newArrayList((Object[])new String[]{"soyTransformer", "stashJsHelp", "stashJsI18n", "jsI18n"})).put((Object)"less", (Object)Lists.newArrayList((Object[])new String[]{"less-transformer"})).build();
    private Element originalElement;
    private Element derivedElement;
    private static final Logger log = LoggerFactory.getLogger(StashResourceModuleDescriptor.class);
    private final PluginPathScannerFactory pluginPathScannerFactory;

    public StashResourceModuleDescriptor(HostContainer hostContainer, PluginPathScannerFactory pluginPathScannerFactory) {
        super(hostContainer);
        this.pluginPathScannerFactory = pluginPathScannerFactory;
    }

    public Element getElement() {
        return this.derivedElement;
    }

    public Element getOriginalElement() {
        return this.originalElement;
    }

    public Void getModule() {
        return null;
    }

    public void init(Plugin plugin, Element element) throws PluginParseException {
        this.originalElement = element;
        this.derivedElement = element.createCopy();
        for (Map.Entry<String, Collection<String>> entry : RESOURCE_TRANSFORMS.entrySet()) {
            this.addTransforms(this.derivedElement, entry.getKey(), (Iterable<String>)entry.getValue());
        }
        super.init(plugin, this.derivedElement);
    }

    public void enabled() {
        super.enabled();
        this.addResourceElements(this.derivedElement);
        this.resources = Resources.fromXml((Element)this.derivedElement);
    }

    private String changeFileExtension(String path, String oldExtension, String newExtension) {
        if (path.endsWith(oldExtension)) {
            return path.substring(0, path.length() - oldExtension.length()) + newExtension;
        }
        return path;
    }

    private String getNameFromLocation(String location, String directoryToScan) {
        String name = location.substring(directoryToScan.length());
        name = this.changeFileExtension(name, ".less", ".css");
        name = this.changeFileExtension(name, ".soy", ".soy.js");
        return name;
    }

    private Set<String> getPredefinedResources(Element resourceContainer) {
        HashSet predefinedResources = Sets.newHashSet();
        for (Object resourceObj : resourceContainer.elements("resource")) {
            String location;
            Element resource = (Element)resourceObj;
            if (!"download".equalsIgnoreCase(resource.attributeValue("type")) || !StringUtils.isNotBlank((String)(location = resource.attributeValue("location")))) continue;
            predefinedResources.add(location);
        }
        return predefinedResources;
    }

    private Set<String> getExcludedPatterns(Element directoryElement) {
        return this.getPatterns(directoryElement, "exclude");
    }

    private Set<String> getIncludedPatterns(Element directoryElement) {
        return this.getPatterns(directoryElement, "include");
    }

    private Set<String> getPatterns(Element directoryElement, String attributeName) {
        HashSet excludes = Sets.newHashSet();
        for (Object excludesObj : directoryElement.elements(attributeName)) {
            String exclude = ((Element)excludesObj).getText();
            if (!StringUtils.isNotBlank((String)exclude)) continue;
            Collections.addAll(excludes, exclude.split(","));
        }
        return excludes;
    }

    private void addResourceElements(Element resourceContainer) {
        Set<String> predefinedResources = this.getPredefinedResources(resourceContainer);
        Element directory = this.originalElement.element("directory");
        if (directory != null) {
            this.addResourceElementsForDirectory(directory, resourceContainer, predefinedResources);
        }
        ArrayList excludeTransforms = Lists.newArrayList();
        Attribute excludeTransformsAttr = this.originalElement.attribute("excludeTransforms");
        if (excludeTransformsAttr != null) {
            Collections.addAll(excludeTransforms, excludeTransformsAttr.getValue().split(","));
        }
        if (directory != null) {
            this.originalElement.remove(directory);
        }
    }

    private void addResourceElementsForDirectory(Element directory, Element resourceContainer, Set<String> predefinedResources) {
        Set<String> excludedPatterns = this.getExcludedPatterns(directory);
        Set<String> includedPatterns = this.getIncludedPatterns(directory);
        String directoryToScan = this.normalizedDirectory(directory.attributeValue("location"));
        boolean isWebContextStatic = "webContextStatic".equalsIgnoreCase(directory.attributeValue("source"));
        PluginPathScanner scanner = this.pluginPathScannerFactory.forPlugin(this.plugin, isWebContextStatic);
        if (StringUtils.isNotBlank((String)directoryToScan)) {
            for (String location : scanner.getPaths(directoryToScan)) {
                if (predefinedResources.contains(location)) {
                    log.debug("Web resource '{}:{}' explicitly defined, skipping", (Object)this.getCompleteKey(), (Object)location);
                    continue;
                }
                boolean excluded = false;
                if (!excludedPatterns.isEmpty()) {
                    for (String exclude : excludedPatterns) {
                        if (!PATH_MATCHER.match(exclude, location)) continue;
                        excluded = true;
                        break;
                    }
                }
                if (excluded) continue;
                boolean included = true;
                if (!includedPatterns.isEmpty()) {
                    included = false;
                    for (String include : includedPatterns) {
                        if (!PATH_MATCHER.match(include, location)) continue;
                        included = true;
                    }
                }
                if (!included) continue;
                String name = this.getNameFromLocation(location, directoryToScan);
                Element e = resourceContainer.addElement("resource");
                e.addAttribute("type", "download");
                e.addAttribute("name", name);
                e.addAttribute("location", location);
                if (!isWebContextStatic) continue;
                Element param = e.addElement("param");
                param.addAttribute("name", "source");
                param.addAttribute("value", "webContextStatic");
            }
        } else {
            log.info("<directory> element 'location' attribute not present for module '{}', skipping automatic resource generation", (Object)this.getCompleteKey());
        }
    }

    private String normalizedDirectory(String location) {
        if (!Strings.isNullOrEmpty((String)location)) {
            location = location.endsWith("/") ? location : location + "/";
            location = location.startsWith("/") ? location : "/" + location;
        }
        return location;
    }

    private void addTransforms(Element container, String fileExtension, Iterable<String> transformKeys) {
        Element e = container.addElement("transformation");
        e.addAttribute("extension", fileExtension);
        for (String key : transformKeys) {
            Element t = e.addElement("transformer");
            t.addAttribute("key", key);
        }
    }
}

