/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.stash.internal.plugin.PluginSettingDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component(value="pluginSettingsFactory")
@AvailableToPlugins(value=PluginSettingsFactory.class)
public class StashPluginSettingsFactoryImpl
implements PluginSettingsFactory {
    public static final String GLOBAL_SETTING_NAMESPACE = "stash.global.settings";
    private final PluginSettingDao keyValueStore;
    private final ApplicationContext applicationContext;

    @Autowired
    public StashPluginSettingsFactoryImpl(ApplicationContext applicationContext, PluginSettingDao keyValueStore) {
        this.applicationContext = applicationContext;
        this.keyValueStore = keyValueStore;
    }

    public PluginSettings createGlobalSettings() {
        return this.createSettingsForKey(GLOBAL_SETTING_NAMESPACE);
    }

    public PluginSettings createSettingsForKey(String key) {
        return (PluginSettings)this.applicationContext.getBean("pluginSettingsPrototype", new Object[]{this.keyValueStore, key});
    }
}

