/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.plugin.manager.PluginPersistentState;
import com.atlassian.plugin.manager.PluginPersistentStateStore;
import com.atlassian.stash.internal.plugin.PluginState;
import com.atlassian.stash.internal.plugin.PluginStateDao;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class DefaultPluginPersistentStateStore
implements PluginPersistentStateStore {
    private final PluginStateDao pluginStateDao;

    public DefaultPluginPersistentStateStore(PluginStateDao pluginStateDao) {
        this.pluginStateDao = pluginStateDao;
    }

    @Transactional(readOnly=true)
    public PluginPersistentState load() {
        HashMap<String, Boolean> state = new HashMap<String, Boolean>();
        for (PluginState pluginState : this.pluginStateDao.findAll()) {
            state.put(pluginState.getName(), pluginState.isEnabled());
        }
        return PluginPersistentState.Builder.create().addState(state).toState();
    }

    public void save(PluginPersistentState state) {
        this.pluginStateDao.clear();
        Set set = state.getMap().entrySet();
        for (Map.Entry e : set) {
            this.pluginStateDao.create((Object)new PluginState((String)e.getKey(), ((Boolean)e.getValue()).booleanValue()));
        }
    }
}

