/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.process;

import com.atlassian.utils.process.DefaultExternalProcessFactory;
import com.atlassian.utils.process.ExternalProcess;
import com.atlassian.utils.process.ExternalProcessBuilder;
import com.atlassian.utils.process.ExternalProcessFactory;
import com.atlassian.utils.process.ExternalProcessSettings;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="externalProcessFactory")
public class ConfigurableExternalProcessFactory
extends DefaultExternalProcessFactory {
    private long executionTimeout;
    private long idleTimeout;

    public ExternalProcess create(ExternalProcessSettings settings) {
        settings.setSuppressSpecialWindowsBehaviour(true);
        if (!settings.hasExecutionTimeout()) {
            settings.setExecutionTimeout(this.executionTimeout);
        }
        if (!settings.hasIdleTimeout()) {
            settings.setIdleTimeout(this.idleTimeout);
        }
        return super.create(settings);
    }

    @PostConstruct
    public void initialise() {
        ExternalProcessBuilder.setExternalProcessFactory((ExternalProcessFactory)this);
    }

    @Value(value="${process.timeout.execution}")
    public void setExecutionTimeout(long executionTimeout) {
        this.executionTimeout = TimeUnit.SECONDS.toMillis(executionTimeout);
    }

    @Value(value="${process.timeout.idle}")
    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = TimeUnit.SECONDS.toMillis(idleTimeout);
    }

    @PreDestroy
    public void shutdown() {
        super.shutdown();
    }
}

