/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.event.config.ListenerHandlersConfiguration;
import com.atlassian.event.spi.ListenerHandler;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.osgi.factory.descriptor.ComponentImportModuleDescriptor;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;

public class EventListenerRegistrar
implements DestructionAwareBeanPostProcessor {
    private static final Set<String> BLACKLISTED_PLUGIN_KEYS = ImmutableSet.of((Object)"com.atlassian.upm.atlassian-universal-plugin-manager-plugin", (Object)"com.atlassian.activeobjects.activeobjects-plugin", (Object)"com.atlassian.applinks.applinks-plugin", (Object)"com.atlassian.crowd.embedded.admin", (Object)"com.atlassian.oauth.admin", (Object)"com.atlassian.oauth.consumer", (Object[])new String[]{"com.atlassian.oauth.consumer.sal", "com.atlassian.oauth.serviceprovider", "com.atlassian.oauth.serviceprovider.sal", "com.atlassian.plugins.rest.atlassian-rest-module", "com.atlassian.soy.soy-template-plugin", "com.atlassian.templaterenderer.api", "com.atlassian.templaterenderer.atlassian-template-renderer-velocity1.6-plugin", "com.atlassian.auiplugin"});
    private static final Logger log = LoggerFactory.getLogger(EventListenerRegistrar.class);
    private final EventPublisher eventPublisher;
    private final ListenerHandlersConfiguration listenerHandlersConfiguration;
    private final Multimap<String, Object> eventListenersFromPlugins = HashMultimap.create();

    @Autowired
    public EventListenerRegistrar(EventPublisher publisher, ListenerHandlersConfiguration listenerHandlersConfiguration) {
        this.eventPublisher = publisher;
        this.listenerHandlersConfiguration = listenerHandlersConfiguration;
        this.registerIfEventListener(null, this);
    }

    public void postProcessBeforeDestruction(Object bean, String beanName) throws BeansException {
        this.eventPublisher.unregister(bean);
    }

    private void registerIfEventListener(String key, Object bean) {
        if (bean != null) {
            for (ListenerHandler handler : this.listenerHandlersConfiguration.getListenerHandlers()) {
                if (handler.getInvokers(bean).isEmpty()) continue;
                if (key != null) {
                    this.eventListenersFromPlugins.put((Object)key, bean);
                }
                this.eventPublisher.register(bean);
                break;
            }
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        this.registerIfEventListener(null, bean);
        return bean;
    }

    @PluginEventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        Plugin plugin = event.getPlugin();
        if (BLACKLISTED_PLUGIN_KEYS.contains(plugin.getKey())) {
            return;
        }
        for (ModuleDescriptor moduleDescriptor : plugin.getModuleDescriptors()) {
            if (moduleDescriptor.getClass().equals(ComponentImportModuleDescriptor.class) || moduleDescriptor.getModuleClass() == null || moduleDescriptor.getModuleClass().equals(Void.class)) continue;
            Object module = null;
            try {
                module = moduleDescriptor.getModule();
            }
            catch (Exception e) {
                continue;
            }
            try {
                this.registerIfEventListener(plugin.getKey(), module);
            }
            catch (Throwable t) {
                log.error("Error registering eventlisteners for module " + moduleDescriptor.getCompleteKey() + "; skipping.", t);
            }
        }
    }

    @PluginEventListener
    public void onPluginDisabled(PluginDisabledEvent event) {
        Plugin plugin = event.getPlugin();
        Collection listeners = this.eventListenersFromPlugins.get((Object)plugin.getKey());
        if (listeners != null) {
            for (Object eventListener : listeners) {
                this.eventPublisher.unregister(eventListener);
            }
            this.eventListenersFromPlugins.removeAll((Object)plugin.getKey());
        }
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

